/**
 * 
 */
package scroll;

import java.util.ListIterator;


public interface Scroll<E> extends Iterable<E> {
    
    //=================================
    // Primary Methods
    //=================================
    
    /**
     * Insert an element onto this scroll
     * @param element the element to be  added to this scroll
     * @throws IllegalArgumentException if this stack is full.
     */
    public void insert(E element) throws IllegalArgumentException;
    
    /**
     * Delete the element to the right of the cursor. 
     * @throws IllegalStateException if this position is empty.
     */ 
    public E delete() throws IllegalStateException;
    
    /**
     * Advances the cursor one element to the right.
     * * @throws IllegalStateException if this position is empty.
     */
    public void advance() throws IllegalStateException;
    
    /**
     * Retreats the cursor one element to the left.
     */
    public void retreat();
    
    /**
     * Resets the cursor to the beginning of the scroll.
     */
    public void reset();
    
    /**
     * Advances the cursor to the end of the scroll
     */
    public void advanceToEnd();
    
    /**
     * The number of elements to the left of the cursor
     * @return
     */
    public int leftLength();
    
    /**
     * The number of elements to the right of the cursor
     * @return
     */
    public int rightLength();
    
    /**
     * Swaps the right part of this scroll with the right part of that scroll.
     * @param that scroll will be swapped
     */
    public void swapRights(Scroll<E> that);
    
    //=================================
    // Secondary Methods
    //=================================
    
    /**
     * Gets a handle to (does not remove) the element to the right of the cursor.
     * @return
     */
    public E getNext();
    
    /**
     * Gets a handle to the element to the left of the cursor.
     * @return
     */
    public E getPrevious();
    
    /**
     * Replaces the element to the the right of the cursor and returns the original.
     * @param element the element to be replaced
     * @return
     */
    public E replace(E element);
    
    /**
     * Adds all the elements from that scroll to the right of the cursor in this scroll
     * @param that the elements to be added to the right of the cursor
     */  
    public void splice(Scroll<E> that);
    
    /**
     * Moves all the elements from the right of the cursor 
     * to the left of the cursor in reverse order
     * @throws IllegalStateException if the left sequence is not empty.
     */
    public void reverse() throws IllegalStateException;
    
    /**
     * A list iterator that starts at the cursor position
     * @return
     */ 
    public ListIterator<E> listIterator();
    /**
     * A list iterator that starts at the beginning of the scroll
     * @return
     */
    public ListIterator<E> resetListIterator();

    
}
