import java.util.*;

/**
 * Prepared for COSC 322
 * For Testing and Demo.
 * 
 * @author yong.gao@ubc.ca
 *
 */

public class CSP322 {
	
    public static void main (String args[]) {
    	
    	 //Should be found unsatisfiable during pre-processing with arc-consistency;
    	 //Without arc-consistency, should be found unsatisfiable  after a number of backtrackings  
         testCircleTwoColoring(21, 2);
         
         //With forward checking, we should find a solution without backtracking
         testCircleTwoColoring(20, 2); 
        
        //with forward checking and arc consistency, it can handle graphs of 100 nodes with ease   
		testRandomGraphColoring();
    }
	
    
    /**
     * Testing two colorability on a cycle
     * @param N
     * @param K
     */
	public static void testCircleTwoColoring(int N, int K){
	
		CSPSolver  solver = new CSPSolver();
		
		//the constraint graph is a circle with N nodes
		Constraint[][] C = new Constraint[N][N];
		Constraint c = new Constraint();
		for(int i = 0; i < N - 1; i++){
		     C[i][i+1] = c;
		     C[i + 1][i] = c;
 
		} 
		C[0][N-1] = c;
		C[N - 1][0] = c;
		
		int[][] domains = new int[N][K]; 
		
		for(int i = 0; i < N; i++){
		   for(int j = 0; j < K; j++){
		      domains[i][j] = -1;
		   }
		}
		
		domains[N-1][1] = -2; // delete 0 from the domain of x_0 for testing purposes 
		
		CSPInstance csp = new CSPInstance(C, domains); 
		
	    solver.solve(csp, ConstraintPropagator.CONSISTENCY_LEVEL_ARC_CONSISTENCY);	
	}
    
    
    
    
	public static void testRandomGraphColoring()
	{
	   int K = 3;    		// number of colors 
	   int N = 30;   		// number of nodes
	   double T = 4.0 / N;  // probability of a constraint 
	   	
	   Constraint[][] C = new Constraint[N][N];
	   Random r = new Random();  
	   
	   
	   Constraint c = new Constraint();
	   int M = 0;
	   for(int i = 0; i < N - 1; i++){
	      for (int j = i+1; j < N; j++){
		      if(r.nextDouble() < T){
			    C[i][j] = c;
			    C[j][i] = c;
				M++;
			  }  
		  }
	   }
	    	
	   int[][] domains = new int[N][K];
	
	   for(int i = 0; i < N; i++){
		   for(int j = 0; j < K; j++){
		      domains[i][j] = -1;
		   }
		}
	    
	    CSPInstance csp = new CSPInstance(C, domains); 
	   
		CSPSolver solver = new CSPSolver();
		solver.solve(csp, ConstraintPropagator.CONSISTENCY_LEVEL_ARC_CONSISTENCY);	
	}
 
}


