import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

/**
 * A static class for functions that implement constraint propagation methods.  Prepared for COSC 322
 * 
 * @author yong.gao@ubc.ca
 *
 */

public class ConstraintPropagator {
	
	private static boolean runConsistencyChecking = false;
	
	public final static int CONSISTENCY_LEVEL_FORWARD_CHECKING = 1;
	public final static int CONSISTENCY_LEVEL_ARC_CONSISTENCY = 2;
	public final static int CONSISTENCY_LEVEL_PATH_COSISTENCY = 3;
	
	/**
	 * Implements the forward checking method
	 * 
	 * @param csp: the CSP instance
	 * @param currentLevel: the current level of the search tree. Equal to the index of the current variable
	 * @param currentValue: the value currently assigned to the current variable x_currentLevel
	 * @return false if the domain of some variable becomes empty after the forward checking
	 */	
	   //You are required to implement this function to do the forward-checking
	   //If a domain value k of a variable x_j is not compatible with the assignment
	   //x_current = value, "delete" k by letting domains[j][k] = current  
	   //
	   //Return false only if some variable's domain becomes empty  	
	public static boolean forwardChecking(CSPInstance csp, int currentLevel, int currentValue){
	    return true; //does nothing currently 	 
	}//end of forwardChecking
	
	
	/**
	 * Implements the arc consistency method 
	 * @param csp: the csp instance
	 * @param currentLevel: the current level in the search tree. Equal to the index of the current variable
	 * @return false if the domain of some variable becomes empty after arc consistency maintaining 
	 */
	   //You are required to implement this function to maintain the arc consistency 
	   //Delete value j of variable i by assigning domains[i][j] = currentLvel
	   //
	   //Return false when some variable's domain becomes empty 
	
	public static boolean arcConsistency(CSPInstance csp, int currentLevel){
		return true; //does nothing currently 
	}//end of arcConsistency
	
}//end of class
