/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

import java.util.ArrayList;

public class SeaPort extends Thing {

    private ArrayList<Dock> docks;
    private ArrayList<Ship> que;
    private ArrayList<Ship> ships;
    private ArrayList<Person> persons;

    //Constructor
    public SeaPort(ArrayList<Dock> docks, ArrayList<Ship> que,
            ArrayList<Ship> ships, ArrayList<Person> persons) {
        super();
        this.docks = docks;
        this.que = que;
        this.ships = ships;
        this.persons = persons;
    }
    
    //Getters and setters
    public ArrayList<Dock> getDocks() {
        return docks;
    }

    public void setDocks(ArrayList<Dock> docks) {
        this.docks = docks;
    }

    public ArrayList<Ship> getQue() {
        return que;
    }

    public void setQue(ArrayList<Ship> que) {
        this.que = que;
    }

    public ArrayList<Ship> getShips() {
        return ships;
    }

    public void setShips(ArrayList<Ship> ships) {
        this.ships = ships;
    }

    public ArrayList<Person> getPersons() {
        return persons;
    }

    public void setPersons(ArrayList<Person> persons) {
        this.persons = persons;
    }

    //toString creation
    public String toString() {
        String st = "\n\nSeaPort: " + super.toString();
        for (Dock md : docks) {
            st += "\n" + md;
        }
        st += "\n\n --- List of all ships in que:";
        for (Ship ms : que) {
            st += "\n   > " + ms;
        }
        st += "\n\n --- List of all ships:";
        for (Ship ms : ships) {
            st += "\n   > " + ms;
        }
        st += "\n\n --- List of all persons:";
        for (Person mp : persons) {
            st += "\n   > " + mp;
        }
        return st;
    }

}
