/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

import java.awt.BorderLayout;
import java.awt.event.*;
import java.io.*;
import java.util.Scanner;
import javax.swing.*;

public class SeaPortGui extends JFrame {

    private World world;
    JTextArea textArea = new JTextArea();
    JTextField textField;

    //Constructor
    public SeaPortGui() {
        setTitle("Sea Port Application");
        setSize(640, 480);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setVisible(true);
        
        JScrollPane jsp = new JScrollPane(textArea);
        add(jsp, BorderLayout.CENTER);

        JButton button = new JButton("Read File");

        JPanel panel = new JPanel();
        panel.add(button);

        add(panel, BorderLayout.PAGE_START);

        validate();

        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    readFile();
                } catch (FileNotFoundException fe) {
                    fe.printStackTrace();
                }
            }
        }
        );

    }

    //Methods
    public void readFile() throws FileNotFoundException {
        JFileChooser chooser = new JFileChooser(".");
        int option = chooser.showOpenDialog(SeaPortGui.this);
        if (option == JFileChooser.APPROVE_OPTION) {
            File selectFile = chooser.getSelectedFile();
            Scanner scanner = new Scanner(selectFile);
            while (scanner.hasNext()) {
                String line = scanner.nextLine();

                if (line.contains("//") == false) {
                    textArea.append(line + "\n");

                }
            }
        }

    }

    //Main method
    public static void main(String[] args) {
        SeaPortGui sg = new SeaPortGui();
    }
}
