//
//  ViewController.swift
//  WApp
//
//  Created by Siddhesh Keluskar on 21/10/16.
//  Copyright © 2016 Siddhesh. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UITableViewDelegate, UITableViewDataSource {
    var weather: [String] = []
    var forecast: [String] = []

    
    @IBOutlet var city_text: UITextField!
    @IBOutlet
    var tableView: UITableView?
    var items: [String] = ["clear sky","clear sky","few clouds","rain","rain"]
    
       override func viewDidLoad() {
        super.viewDidLoad()
    
      
        
        // Do any additional setup after loading the view, typically from a nib.
        
        let urlString = "http://api.openweathermap.org/data/2.5/forecast?q="+city_text.text!+",us&mode=JSON&appid=616f6f661d4199b09d3b088756614660"
        
        let url = URL(string: urlString)
        URLSession.shared.dataTask(with:url!, completionHandler: {(data, response, error) in
            if error != nil {
                print(error!)
            } else {
                do {
                    
                    let allContactsData = try Data(contentsOf: url!)
                    let parsedData = try JSONSerialization.jsonObject(with: allContactsData, options: JSONSerialization.ReadingOptions.allowFragments) as! [String : AnyObject]
                    if let arrJSON = parsedData["list"] {
                        for index in 0...arrJSON.count-1 {
                        let aObject = arrJSON[index] as! [String : AnyObject]
                            let weather1 =  aObject["weather"]![0] as! [String:AnyObject]
                          self.weather.append(weather1["description"] as! String)
                     
                        }
                        
                
                        print(self.weather.count)
                        self.forecast = [self.weather[0],self.weather[7],self.weather[15],self.weather[23],self.weather[31]]
                        
                        self.items = self.forecast
                        
                        self.tableView?.reloadData()
                    }
                    
                } catch let error as NSError {
                    print(error)
                }
            }
            
        }).resume()
        self.tableView?.register(UITableViewCell.self, forCellReuseIdentifier: "cell")
        
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.items.count;
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        var cell:UITableViewCell = self.tableView!.dequeueReusableCell(withIdentifier: "cell")! as UITableViewCell
        
        cell.textLabel?.text = self.items[indexPath.row]
        
        return cell
    }
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        print("You selected cell #\(indexPath.row)!")
    }
    
    @IBAction func button(_ sender: UIButton) {
        viewDidLoad()
    }
}

