
package customermaintapp;

import java.io.*;
import java.nio.file.*;
import java.util.ArrayList;

public class CustomerTextFile implements CustomerDAO {
    private ArrayList<Customer> customers = null;
    private Path customersPath = null;
    private File customersFile = null;
    private final String FIELD_SEP = "\t";
    private final String line_sep = System.lineSeparator();
    
    public CustomerTextFile(){
        customersPath = Paths.get("Customers.txt");
        customersFile = customersPath.toFile();
        customers = this.getCustomers();
    }
    
    public static String padWithSpaces(String s, int length)
    {
        if (s.length() < length)
        {
            StringBuilder sb = new StringBuilder(s);
            while(sb.length() < length)
            {
                sb.append(" ");
            }
            return sb.toString();
        }
        else
        {
            return s.substring(0, length);
        }
    }

    
    @Override
    public Customer getCustomer(String email) {
        for (Customer c: customers){
            if (c.getEmail().equals(email))
                    return c;
        }
        return null;
    }
       

    
    @Override
    public ArrayList<Customer> getCustomers() {
        if(customers!=null)
            return customers;
        customers = new ArrayList<>();
        if(Files.exists(customersPath)){
            try(BufferedReader in = new BufferedReader(
                                    new FileReader(customersFile))){
                String line = in.readLine();
                while(line!=null){
                    String[] columns = line.split(FIELD_SEP);
                    String email = columns[0];
                    String fName = columns[1];
                    String lName = columns[2];
                    Customer c = new Customer(email, fName, lName);
                    customers.add(c);
                    line = in.readLine();
                }
            }    
            catch(IOException e){
                System.out.println(e);
                return null;
            }
        }
        return customers;
    }
    
    

    @Override
    public boolean addCustomer(Customer c) {
        boolean custExist = false;
        for(Customer c1:customers){
            if (c1.emailID.equalsIgnoreCase(c.emailID))
                custExist= true;
        }
        if(custExist){
            System.out.println("Customer already exists with this emmail ID");
            return false;
        }
        else{
        customers.add(c);
        return this.saveCustomers();
        }
    }

    

    @Override
    public boolean deleteCustomer(Customer c) {
        customers.remove(c);
        return this.saveCustomers();
    }
    
    private boolean saveCustomers(){
        try(PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(customersFile))))
        {
            for (Customer c: customers){
                out.print(c.getEmail()+FIELD_SEP);
                out.print(c.getFName()+FIELD_SEP);
                out.print(c.getLName()+line_sep);    
                
            }
        }
        catch(IOException e){
            System.out.println(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateCustomer(Customer newCustomer) {
    Customer oldCustomer = this.getCustomer(newCustomer.getEmail());
    int i = customers.indexOf(oldCustomer);
    customers.remove(i);
    customers.add(newCustomer);
    return this.saveCustomers();
            
    }

    @Override
    public String getCustomersString() {
        Customer c = null;
        String s = "";
        for (int i = 0; i < customers.size(); i++)
        {
            c = customers.get(i);
            String col1 =
                this.padWithSpaces(c.getEmail(), EMAIL_SIZE + 4);
            String col2 =
                this.padWithSpaces(c.getFName(), FNAME_SIZE + 4);
            s += col1 + col2 + c.getLName() + "\n";
        }
        return s;
    }

   
}
