#include "BankControl.h"
#include "Account.h"

BankControl::BankControl()
{
  init();
}

void BankControl::launch()
{
  int choice;

  while (1) {
    choice = -1;
    view.mainMenu(choice);
    if (choice == 1) {		// Admin menu
      processAdmin();
    }
    else if (choice == 2) {	// Customer menu
      processCust();
    }
    else {
      break;
    }
  }
}

void BankControl::processAdmin()
{
  int      choice;
  int      custId;
  AcctType acctType;

  while (1) {
    choice = -1;
    view.adminMenu(choice);
    if (choice == 1) {		// add account
      view.readCustId(custId);
      //Find/Check the customer Id on the bank
      if (bank.getCustomers().find(custId))
			{
        view.readAcctType(acctType);
        Account* acct = new Account(custId, acctType);

		    bank.addAcct(acct);
			}
      view.pause();
    }
    else if (choice == 2) {	// print accounts
      view.printAccounts(bank);
      view.pause();
    }
    else if (choice == 3) { //print customers
    	view.printCustomers(bank);
    	view.pause();
    }
    else {
      break;
    }
  }
}

void BankControl::processCust()
{
  int choice;
	int      acctNum;

  while (1) {
    choice = -1;
    view.custMenu(choice);
    if (choice == 1) {	// check balance
				view.readAcctNum(acctNum);
	      //view.printError("Feature not yet implemented");
				view.printBalance(bank, acctNum);
				//view.pause();
    }
    else {
      break;
    }
  }
}

void BankControl::init()
{
  /*
     This function is so ugly!  It's because we're using 
     statically allocated memory, instead of dynamically
     alloated.  Don't worry, we'll fix this in Assignment #2.
  */
	Account* acct;
	Customer* cust;

  acct = new Account(1001, SAVINGS);
  bank.addAcct(acct);
  acct = new Account(1001, SAVINGS);
  bank.addAcct(acct);
  acct = new Account(1001, CHEQUING);
  bank.addAcct(acct);

  acct = new Account(1002, SAVINGS);
  bank.addAcct(acct);
  acct = new Account(1002, CHEQUING);
  bank.addAcct(acct);

  acct = new Account(1003, SAVINGS);
  bank.addAcct(acct);
  acct = new Account(1003, CHEQUING);
  bank.addAcct(acct);
  acct = new Account(1003, CHEQUING);
  bank.addAcct(acct);

  acct = new Account(1004, CHEQUING);
  bank.addAcct(acct);

  acct = new Account(1006, SAVINGS);
  bank.addAcct(acct);
  acct = new Account(1006, CHEQUING);
  bank.addAcct(acct);

  acct = new Account(1007, CHEQUING);
  bank.addAcct(acct);
  acct = new Account(1007, CHEQUING);
  bank.addAcct(acct);

  acct = new Account(1012, SAVINGS);
  bank.addAcct(acct);
  acct = new Account(1012, SAVINGS);
  bank.addAcct(acct);
/*
  Account acc01(1001, SAVINGS);
  bank.addAcct(acc01);
  Account acc02(1001, SAVINGS);
  bank.addAcct(acc02);
  Account acc03(1001, CHEQUING);
  bank.addAcct(acc03);

  Account acc04(1002, SAVINGS);
  bank.addAcct(acc04);
  Account acc05(1002, CHEQUING);
  bank.addAcct(acc05);

  Account acc06(1003, SAVINGS);
  bank.addAcct(acc06);
  Account acc07(1003, CHEQUING);
  bank.addAcct(acc07);
  Account acc08(1003, CHEQUING);
  bank.addAcct(acc08);

  Account acc09(1004, CHEQUING);
  bank.addAcct(acc09);

  Account acc10(1006, SAVINGS);
  bank.addAcct(acc10);
  Account acc11(1006, CHEQUING);
  bank.addAcct(acc11);

  Account acc12(1007, CHEQUING);
  bank.addAcct(acc12);
  Account acc13(1007, CHEQUING);
  bank.addAcct(acc13);

  Account acc14(1012, SAVINGS);
  bank.addAcct(acc14);
  Account acc15(1012, SAVINGS);
  bank.addAcct(acc15);*/
  /*
  Customer cust01(1001, "Michael Jackson");
  bank.addCust(&cust01);
  
  Customer cust02(1002, "John May");
  bank.addCust(&cust02);
  
  Customer cust03(1003, "Michael Phelps");
  bank.addCust(&cust03);  
  
  Customer cust04(1004, "Barack Obama");
  bank.addCust(&cust04);
  
  Customer cust05(1005, "Bill Gates");
  bank.addCust(&cust05);
  
  Customer cust06(1006, "Clinton Something");
  bank.addCust(&cust06);
  
  Customer cust07(1007, "Mike Michael");
  bank.addCust(&cust07);
  
  Customer cust08(1008, "John Johny Johnson");
  bank.addCust(&cust08);
  
  Customer cust09(1009, "Ian Bubble");
  bank.addCust(&cust09);
  
  Customer cust10(1010, "Mr Clown");
  bank.addCust(&cust10);
  
  Customer cust11(1011, "Muffin Guy");
  bank.addCust(&cust11);
  
  Customer cust12(1012, "Visual Studio guy");
  bank.addCust(&cust12);*/
	//cust[0] = new Customer(1012, "Visual Studio guy");
	//bank.addCust(cust[0]);

  cust = new Customer(1001, "Michael Jackson");
  bank.addCust(cust);
  
  cust = new Customer(1002, "John May");
  bank.addCust(cust);
  
  cust = new Customer(1003, "Michael Phelps");
  bank.addCust(cust);  
  
  cust = new Customer(1004, "Barack Obama");
  bank.addCust(cust);
  
  cust = new Customer(1005, "Bill Gates");
  bank.addCust(cust);
  
  cust = new Customer(1006, "Clinton Something");
  bank.addCust(cust);
  
  cust = new Customer(1007, "Mike Michael");
  bank.addCust(cust);
  
  cust = new Customer(1008, "John Johny Johnson");
  bank.addCust(cust);
  
  cust = new Customer(1009, "Ian Bubble");
  bank.addCust(cust);
  
  cust = new Customer(1010, "Mr Clown");
  bank.addCust(cust);
  
  cust = new Customer(1011, "Muffin Guy");
  bank.addCust(cust);
  
  cust = new Customer(1012, "Visual Studio guy");
  bank.addCust(cust);

/*
  cust[0] = new Customer(1001, "Michael Jackson");
  bank.addCust(cust[0]);
  
  cust[1] = new Customer(1002, "John May");
  bank.addCust(cust[1]);
  
  cust[2] = new Customer(1003, "Michael Phelps");
  bank.addCust(cust[2]);  
  
  cust[3] = new Customer(1004, "Barack Obama");
  bank.addCust(cust[3]);
  
  cust[4] = new Customer(1005, "Bill Gates");
  bank.addCust(cust[4]);
  
  cust[5] = new Customer(1006, "Clinton Something");
  bank.addCust(cust[5]);
  
  cust[6] = new Customer(1007, "Mike Michael");
  bank.addCust(cust[6]);
  
  cust[7] = new Customer(1008, "John Johny Johnson");
  bank.addCust(cust[7]);
  
  cust[8] = new Customer(1009, "Ian Bubble");
  bank.addCust(cust[8]);
  
  cust[9] = new Customer(1010, "Mr Clown");
  bank.addCust(cust[9]);
  
  cust[10] = new Customer(1011, "Muffin Guy");
  bank.addCust(cust[10]);
  
  cust[11] = new Customer(1012, "Visual Studio guy");
  bank.addCust(cust[11]);
*/
}

