#include <string>
#include <cstdlib>
using namespace std;

#include "CustArray.h"

CustArray::CustArray()
{
  size = 0;
	for (int i = 0; i < MAX_ARR; ++i)
		elements[i] = 0;
}

CustArray::~CustArray()
{
	for (int i = 0; i < MAX_ARR; ++i)
		delete elements[i];
}


int CustArray::getSize() { return size; }

Customer* CustArray::get(int index)
{
  if (index < 0 || index >= size)
    exit(1);
  return elements[index];
}



void CustArray::add(Customer* name)
{
  if (size >= MAX_ARR)
    return;

  elements[size++] = name;
}

//Convert input ID to matched customer name
string CustArray::convertIdToName(int id)
{
	for (int i = 0; i < size; i++)
	{
		if(get(i)->getId() == id)
			return get(i)->getName();
	}
	return "";
}

//Find the current Id on the bank if it is existed
bool CustArray::find(int id)
{
	for (int i = 0; i < size; i++)
	{
		if(get(i)->getId() == id)
		{
			cout<<"The ID exists in our system. Procceed to add..."<<endl;
			return true;
		}
	}
	cout<<"The ID does not exist in our system. Skipped adding..."<<endl;
	return false;
}

