#include <iostream>
#include <iomanip>
#include <string>
#include <sstream>
#include "View.h"
using namespace std;

void View::mainMenu(int& choice)
{
  string str;

  choice = -1;

  cout<< "\n\n\n                   BANKING SYSTEM MAIN MENU\n\n";
  cout<< "          1. Admin menu \n\n";
  cout<< "          2. Customer menu \n\n";
  cout<< "          0. Exit\n\n";

  while (choice < 0 || choice > 2) {
    cout << "Enter your selection:  ";
    choice = readInt();
  }
}

void View::adminMenu(int& choice)
{
  string str;

  choice = -1;

  cout<< "\n\n\n                   BANKING SYSTEM ADMIN MENU\n\n";
  cout<< "          1. Add account \n\n";
  cout<< "          2. Print accounts \n\n";
  cout<< "          3. Print customers \n\n";
  cout<< "          0. Exit\n\n";

  while (choice < 0 || choice > 3) {
    cout << "Enter your selection:  ";
    choice = readInt();
  }
}

void View::custMenu(int& choice)
{
  string str;

  choice = -1;

  cout<< "\n\n\n                   BANKING SYSTEM CUSTOMER MENU\n\n";
  cout<< "          1. Check balance \n\n";
  cout<< "          0. Exit\n\n";

  while (choice < 0 || choice > 1) {
    cout << "Enter your selection:  ";
    choice = readInt();
  }
}

void View::printAccounts(Bank& bank)
{
  // The stringstream class helps us convert from numeric values to string.
  // The I/O manipulation functions help us make the output look pretty.

  stringstream ss;

  cout << endl << "ACCOUNTS: " << endl;

  for (int i=0; i<bank.getAccounts().getSize(); i++) {

    Account* acct = bank.getAccounts().get(i);

    if (acct->getAcctType() == CHEQUING)
      cout << "Chequing:  ";
    else if (acct->getAcctType() == SAVINGS)
      cout << "Savings:   ";
    else
      cout << "General:   ";
	
		//acct.getCust()
    cout << acct->getAcctNum() << "  " << setw(4) << bank.getCustomers().convertIdToName(acct->getCust()) << "  ";

    ss << setw(8) << fixed << setprecision(2) << acct->getBalance();
    cout << "  $" << ss.str() << endl;
    ss.str("");
  }
}



/*Print Customers from the bank*/
void View::printCustomers(Bank& bank)
{
	cout<<endl<<"CUSTOMERS: "<<endl;
	
	for (int i = 0; i < bank.getCustomers().getSize(); i++) {
		Customer* cust = bank.getCustomers().get(i);
		cout<<cust->getId()<<"  "<<setw(4)<<cust->getName()<<endl;
  }
}
/*
void View::printBalance(float b)
{
  // The stringstream class helps us convert from numeric values to string.
  // The I/O manipulation functions help us make the output look pretty.

  stringstream ss;
  ss << setw(8) << fixed << setprecision(2) << b;
  cout << endl << "Your balance is $" << ss.str() << endl << " -- press enter to continue...";
  cin.get();
}*/

void View::printBalance(Bank& bank, int acctNum)
{
  // The stringstream class helps us convert from numeric values to string.
  // The I/O manipulation functions help us make the output look pretty.

	stringstream ss;
	bool idExisted = false;
//  ss << setw(8) << fixed << setprecision(2);
	for (int i = 0; i < bank.getAccounts().getSize(); i++) 
	{
		Account* acct = bank.getAccounts().get(i);
		if (acct->getAcctNum() == acctNum)
		{
			cout << endl << "Your balance is  $" <<  setw(8) << fixed << setprecision(2) << acct->getBalance();
			idExisted = true;
		}
 	}
	if (!idExisted)
	  cout << endl << " -- The Account No. doesn't exist...";
	cout << endl << " -- press enter to continue...";
	cin.get();
}

void View::printError(string err)
{
  cout << endl << err << " -- press enter to continue...";
  cin.get();
}

void View::readCustId(int& id)
{
  string str;

  cout << "Customer id: ";
  getline(cin, str);
  stringstream ss(str);
  ss >> id;
}

void View::readAcctNum(int& acctNum)
{
  string str;

  cout << "Account No.: ";
  getline(cin, str);
  stringstream ss(str);
  ss >> acctNum;
}

void View::readAcctType(AcctType& acctType)
{
  string str;
  int    num;

  cout << "Account type [1 for chequing, 2 for savings]: ";
  getline(cin, str);
  stringstream ss(str);
  ss >> num;

  if (num == 1)
    acctType = CHEQUING;
  else if (num == 2)
    acctType = SAVINGS;
  else
    acctType = GENERAL;
}

int View::readInt()
{
  string str;
  int    num;

  getline(cin, str);
  stringstream ss(str);
  ss >> num;

  return num;
}

void View::pause()
{
  string str;

  cout << endl << "\nPress enter to continue...";
  getline(cin, str);
}

/*bool View::checkExist(int acct, Bank& bank)
{
	//Checking existing. In intialize stage in BankControl, the Account was intialized first, so the customers array's size here is 0.
	for (int i = 0; i < bank.getCustomers().getSize(); i++)
	{
		cout<<bank.getCustomers().get(i).getId()<<endl;
		if (bank.getCustomers().get(i).getId() == acct);
		{
			cout<<"This ID is existed on our bank. Proceed to add..."<<"("<<i<<")"<<bank.getCustomers().get(i).getId()<<" = " <<acct<<endl;
			return true;
		}
	}
	return false;
}*/

