
package library.domain;

/**
 *
 * @author 
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*

 */
public class Book implements Serializable {

    private String isbn;
    private ArrayList<String> authors;

    // Initialize the constructor.
    public Book() {
        super();
        isbn = "";
        setAuthors(new ArrayList<>());
    }

    // Assign constructor.
    public Book(ArrayList<String> authors, String isbn) {
        this.authors = authors;
        this.isbn = isbn;
    }

    // Getters
    public ArrayList<String> getAuthors() {
        return authors;
    }

    public String getIsbn() {
        return this.isbn;
    }

    // Setters
    public void setAuthors(ArrayList<String> authors) {
        this.authors = authors;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Object)) {
            return false;
        }
        Book b = (Book) obj;

        List<String> authors1 = new ArrayList<>(authors);
        List<String> authors2 = new ArrayList<>(b.authors);

        if (!authors1.equals(authors2)) {
            return false;
        }
        if (b.isbn != isbn) {
            return false;
        }
        return true;

    }

    public boolean validate() {
        if (authors == null || authors.isEmpty()) {
            return false;
        }
        if (isbn == null || isbn.equals("")) {
            return false;
        }
        return true;
    }

    public void addAuthor(String author) {
        authors.add(author);
    }

    @Override
    public String toString() {
        String str = " ISBN: " + isbn + "\n";
        String aName = "";
        for (String s : authors) {
            aName = aName + " " + s;
        }
        return str + aName;
    }

}
