
package library.presentation;

import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import library.business.BookMgr;
import library.domain.Book;

/**
 *
 * @author
 */
public class UI {

    final static boolean RIGHT_TO_LEFT = false;

    public static void addComponentsToPane(Container pane) {
        if (RIGHT_TO_LEFT) {
            pane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }

        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();

        JLabel label = new JLabel("ISBNO:  ", SwingConstants.RIGHT);
        label.setFont(new Font("Monotype Corsiva", Font.PLAIN, 17));
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridx = 0;
        c.gridy = 0;
        pane.add(label, c);

        JTextField isbno = new JTextField(" ");
        c.insets = new Insets(4, 4, 0, 0);  //top and bottom padding
        isbno.setFont(new Font("Monotype Corsiva", Font.PLAIN, 17));
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 0;
        pane.add(isbno, c);

        label = new JLabel("please enter a delimiter between author names (comma or newline) :  ", SwingConstants.LEFT);
        label.setFont(new Font("Monotype Corsiva", Font.PLAIN, 15));
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        pane.add(label, c);

        label = new JLabel("Authors: ", SwingConstants.RIGHT);
        label.setFont(new Font("Monotype Corsiva", Font.PLAIN, 17));
        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor = GridBagConstraints.FIRST_LINE_START; //top of space
        c.gridwidth = 1;
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        pane.add(label, c);

        JTextArea authorsNames = new JTextArea("");
        JScrollPane scroll = new JScrollPane(authorsNames);
        authorsNames.setFont(new Font("Monotype Corsiva", Font.PLAIN, 17));
        c.fill = GridBagConstraints.HORIZONTAL;
        c.ipady = 60;      //make this component tall
        c.weightx = 0.5;
        c.gridwidth = 1;
        //c.gridheight = 3;
        c.gridx = 1;
        c.gridy = 2;
        pane.add(scroll, c);

        JButton add = new JButton("Add");
        add.setFont(new Font("Monotype Corsiva", Font.PLAIN, 17));
        c.fill = GridBagConstraints.HORIZONTAL;
        c.insets = new Insets(10, 0, 4, 0);  //top and bottom padding
        c.weightx = 0.5;
        c.ipady = 0;
        c.gridx = 0;
        c.gridy = 5;
        pane.add(add, c);

        JButton cancel = new JButton("Cancel");
        cancel.setFont(new Font("Monotype Corsiva", Font.PLAIN, 17));
        c.fill = GridBagConstraints.HORIZONTAL;
        c.insets = new Insets(10, 0, 0, 0);  //top padding
        c.weightx = 0.5;
        c.ipady = 0;
        c.gridx = 1;
        c.gridy = 5;
        pane.add(cancel, c);

        cancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                isbno.setText("");
                authorsNames.setText("");
            }
        });

        add.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> authorsList = new ArrayList<>();
                String authorsName = authorsNames.getText().trim();
                BookMgr BookMgr;// = new BookMgr();

                if (authorsName.contains(",")) {
                    String[] authors = authorsName.split(";");
                    for (int i = 0; i < authors.length; i++) {
                        authorsList.add(authors[i].trim());
                    }

                    Book book = new Book(authorsList, isbno.getText().trim());
                    if (book.validate()) {
                        BookMgr = new BookMgr();
                        BookMgr.storeBook(book);
                        System.out.println(book.toString());
                    } else {

                    }

                } else if (authorsName.contains("\n")) {
                    String[] authors = authorsName.split("\n");
                    for (int i = 0; i < authors.length; i++) {
                        authorsList.add(authors[i].trim());
                    }
                    Book book = new Book(authorsList, isbno.getText().trim());
                    if (book.validate()) {
                        BookMgr = new BookMgr();
                        BookMgr.storeBook(book);
                        System.out.println(book.toString());
                    } else {

                    }
                } else {
                    System.out.println("please enter a delimiter between author names (comma or newline)");
                }

            }
        });

    }

    /**
     * Create the GUI and show it.
     */
    private static void createAndShowGUI() {
        //Create and set up the window.
        JFrame frame = new JFrame("Add a Book");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //Set up the content pane.
        addComponentsToPane(frame.getContentPane());

        //Display the window.
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createAndShowGUI();
            }
        });
    }
}
