package application;

import java.util.ArrayList;
import java.util.HashSet;

public class NumSearch {
	static ArrayList<Integer> intList = new ArrayList<Integer>();
	static ArrayList<Integer> sortedIntList = new ArrayList<Integer>();
	
	public static void main(String args[]) {
		int numOfIntsToGenerate = 300000;
		int count, newNum;
		long totalTimeForAryList=0, totalTimeForSortedAryList=0;
		long timeToAddOneNum;
		
		NumGenerator numGen = new NumGenerator(numOfIntsToGenerate*10);

		for (count=0; count < numOfIntsToGenerate; count++) {
			newNum = numGen.retrieveRandomNum();
			
			timeToAddOneNum = addToArrayListNoDuplicates(newNum);
			totalTimeForAryList = totalTimeForAryList + timeToAddOneNum;
			
			timeToAddOneNum = addToSortedArrayListNoDuplicates(newNum);
			totalTimeForSortedAryList = totalTimeForSortedAryList + timeToAddOneNum;
		}
		
		System.out.println("Time for ArrayList (no duplicates): " + totalTimeForAryList/1000000000 + " seconds");
		System.out.println("Time for Sorted ArrayList (no duplicates): " + totalTimeForSortedAryList/1000000000 + " seconds");
		
		System.out.println("\n\nTime for ArrayList (no duplicates): " + totalTimeForAryList/1000000 + " milli-seconds");
		System.out.println("Time for Sorted ArrayList (no duplicates): " + totalTimeForSortedAryList/1000000 + " milli-seconds");
		
	}
	
	/* Add an integer to "sortedIntList" if it is NOT already in the list.   In other words
	 * we don't want duplicates in the list.
	 */
	public static long addToArrayListNoDuplicates(int numToAdd) {
		long startTime = System.nanoTime();
		long endTime, timeInMethod;
		
		/* add code here to:
		 *      Determine if "numToAdd" is already in the arraylist
		 *      If it is already in the arraylist there is nothing to add (since we don't want duplicates)
		 *      If it is not in the arraylist, then add it
		 */
		
		endTime   = System.nanoTime();
		timeInMethod = endTime - startTime;
		return timeInMethod;
	}
	
	/* Add an integer to a SORTED list with no duplicates.   Don't add the
	 * number to the list if it is already in the list.  Make sure the list 
	 * is still sorted after adding the number.
	 */
	public static long addToSortedArrayListNoDuplicates(int numToAdd) {
		long startTime = System.nanoTime();
		long endTime, timeInMethod;
		
		/* add code here to:
		 *      Determine if "numToAdd" is already in the arraylist
		 *      If it is already in the arraylist there is nothing to add (since we don't want duplicates)
		 *      If it is not in the arraylist, then place it in the correct position so the list is STILL SORTED
		 */
		
		endTime   = System.nanoTime();
		timeInMethod = endTime - startTime;
		return timeInMethod;
	}
	
	
}
