/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class Transfer
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    ArrayList<Data> data;
    int current;
    JPasswordField txtpin = new JPasswordField(25);
    JTextField txttnsf = new JTextField(25);
    JTextField txtuser2 = new JTextField(25);
    JTextField txtbal = new JTextField(25);
    JLabel lblpin = new JLabel("Pin Number: ");
    JLabel lbltnsf = new JLabel("Transfer: ");
    JLabel lbluser2 = new JLabel("User Name: ");
    JLabel lblbal = new JLabel("Balance: ");
    JButton btnOk = new JButton("Back to Menu");
    JButton btnRegister = new JButton("Transfer");
    JLabel lblyour = new JLabel("Your Account");
    JLabel lblReciever = new JLabel("Receiver Account");

    public Transfer(ArrayList<Data> ndata, int ncurrent) {
        super("Transfer Funds Transaction");
        this.data = ndata;
        this.current = ncurrent;
        JPanel pane = new JPanel();
        pane.setLayout(null);
        pane.add(this.txtpin);
        pane.add(this.txttnsf);
        pane.add(this.lblpin);
        pane.add(this.lbltnsf);
        pane.add(this.txtuser2);
        pane.add(this.txtbal);
        pane.add(this.lbluser2);
        pane.add(this.lblbal);
        pane.add(this.btnOk);
        pane.add(this.btnRegister);
        pane.add(this.lblyour);
        pane.add(this.lblReciever);
        this.lblpin.setBounds(10, 40, 80, 20);
        this.lbltnsf.setBounds(10, 60, 80, 20);
        this.txtpin.setBounds(100, 40, 100, 20);
        this.txttnsf.setBounds(100, 60, 100, 20);
        this.lbluser2.setBounds(270, 40, 80, 20);
        this.lblbal.setBounds(270, 60, 80, 20);
        this.txtuser2.setBounds(350, 40, 100, 20);
        this.txtbal.setBounds(350, 60, 100, 20);
        this.lblyour.setBounds(100, 10, 140, 20);
        this.lblReciever.setBounds(350, 10, 140, 20);
        this.btnOk.setBounds(175, 140, 140, 20);
        this.btnRegister.setBounds(190, 110, 100, 20);
        this.btnOk.addActionListener(this);
        this.btnRegister.addActionListener(this);
        this.txtbal.setEditable(false);
        this.setContentPane(pane);
        this.setDefaultCloseOperation(0);
        pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Transfer Transaction"));
        this.btnRegister.setToolTipText("Click First then Enter Your Money to Transfer");
        this.btnOk.setToolTipText("Click To Back to Menu");
        this.btnOk.setForeground(Color.yellow);
        this.btnRegister.setForeground(Color.yellow);
        this.btnOk.setBackground(Color.black);
        this.btnRegister.setBackground(Color.black);
        this.lblyour.setForeground(Color.red);
        this.lblReciever.setForeground(Color.red);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnOk) {
            StartATM panel = new StartATM(this.data, this.current);
            panel.setSize(330, 300);
            panel.setVisible(true);
            panel.setResizable(false);
            panel.setLocation(400, 250);
            this.dispose();
        } else if (source == this.btnRegister) {
            String pin = this.txtpin.getText();
            String transfer = this.txttnsf.getText();
            String user = this.txtuser2.getText();
            if (pin.length() == 0 || transfer.length() == 0 || user.length() == 0) {
                JOptionPane.showMessageDialog(null, "Some Fields are empty", "WARNING", 2);
            } else if (pin.compareTo(this.data.get(this.current).getPin()) != 0) {
                JOptionPane.showMessageDialog(null, "PIN is incorrect!", "Security Pin", 2);
                this.txtpin.setText("");
                this.txtpin.requestFocus(true);
            } else {
                try {
                    int wid = Integer.parseInt(transfer);
                    Data update = this.data.get(this.current);
                    if (wid < 20) {
                        JOptionPane.showMessageDialog(null, "The Minimum cash to transfer is $5", "Minimum", 1);
                        this.txttnsf.setText("");
                        this.txttnsf.requestFocus(true);
                    } else if (update.getBalance() < wid) {
                        JOptionPane.showMessageDialog(null, "Insufficient funds to transfer $" + wid, "Insufficient", 2);
                        this.txttnsf.setText("");
                        this.txttnsf.requestFocus(true);
                    } else {
                        boolean found = false;
                        int other = 0;
                        int j = 0;
                        while (j < this.data.size()) {
                            if (this.data.get(j).getUser().compareTo(user) == 0) {
                                found = true;
                                other = j;
                            }
                            ++j;
                        }
                        if (found) {
                            int newbalance = update.getBalance() - wid;
                            update.setBalance(newbalance);
                            this.data.set(this.current, update);
                            Data update2 = this.data.get(other);
                            int newbal = update2.getBalance() + wid;
                            update2.setBalance(newbal);
                            this.data.set(other, update2);
                            this.txtbal.setText("" + newbal);
                            JOptionPane.showMessageDialog(null, "You Transfer $" + wid + " Current Balance $" + newbalance, "Success", 1);
                            this.txttnsf.setText("");
                            this.txtpin.setText("");
                            this.txtuser2.setText("");
                            this.txtpin.requestFocus(true);
                        } else {
                            JOptionPane.showMessageDialog(null, "Receiver Account User not found", "Receiver", 2);
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(null, "Enter dollar amount to Transfer in whole number", "Transfer", 1);
                    this.txttnsf.setText("");
                    this.txttnsf.requestFocus(true);
                }
            }
        }
    }
}

