public abstract class Card implements Comparable<Card>{
  
  /* handy strings for ranks             */
  /* do NOT change these                 */
  public final static String[] RANKS = { "None", "Joker", 
    "2", "3", "4", "5", "6", "7", "8", "9", "10", 
    "Jack", "Queen", "King", "Ace"};
  public final static String[] SUITS = { "Diamonds", 
    "Clubs", "Hearts", "Spades", "None"};
  
  
  
  /* abstract methods you need to implement */
  public abstract int getRank();
  public abstract String getRankString();
  public abstract String getSuit();
  
  
  
  @Override
  public final String toString(){
    // outputs a string representation of a card object
    int r = getRank();
    if( r >= 2 && r <= 14 ){
      return r + getSuit().substring(0,1);
    }else if(r == 1){ // joker
      return "J";
    }
    return "invalid card";
  }
  
}

