public interface HandActions {
 
  
   /* removes and returns a card from the current hand
    * such that the card is a valid card in the game 
    * based on the provided pile of cards 
    */
  Card playCard(Card[] pile);
  
  /* adds one or more cards to the current deck 
   * (given by the input argument) and 
   * possibly discards one or more cards from the 
   * hand (returned)
   */
  Card[] getCard(Card[] cards);
  
  
  /* returns an array of all cards in the current hand */
  Card[] displayHand();
  
  /* returns an array of all cards in the current hand 
   * with the cards in sorted order ("smallest first") based 
   * on the sorting order of the cards used. 
   * (for MyCard cards, diamonds come first, clubs next, 
   * hearts next, spades next and jokers last. Each suit 
   * is also sorted as described in the Cards problem)
   */
  Card[] sortHand();
  
  /* allows user to pass a message to the game */
  String message(String question);
  
}