LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY alu_32 IS
 PORT (in1, in2 : IN std_logic_vector (31 DOWNTO 0);
       aluctrl : IN std_logic_vector (3 DOWNTO 0);
       alu_result : OUT std_logic_vector (31 DOWNTO 0);
       cout: OUT std_logic);
END alu_32;

ARCHITECTURE beh_alu_32 OF alu_32 IS
COMPONENT full_adder_32 IS
 PORT (in1, in2: IN std_logic_vector (31 DOWNTO 0);
         cin: IN std_logic;
         sum: OUT std_logic_vector (31 DOWNTO 0);
         cout: OUT std_logic);
END COMPONENT;

COMPONENT orgate IS
 PORT (in1, in2: IN std_logic_vector (31 DOWNTO 0); 
       q : OUT std_logic_vector (31 DOWNTO 0));
END COMPONENT;

COMPONENT inverter IS
 PORT (in1 : IN std_logic_vector (31 DOWNTO 0);
       q : OUT std_logic_vector (31 DOWNTO 0));
END COMPONENT;

COMPONENT mux_alu IS
  PORT (in0, in1 : IN std_logic_vector (31 DOWNTO 0);
        sel : IN std_logic_vector (3 DOWNTO 0);
        q : OUT std_logic_vector (31 DOWNTO 0));
END COMPONENT;
COMPONENT mux_alu1 IS
  PORT (in0, in1 : IN std_logic_vector (31 DOWNTO 0);
        sel : IN std_logic_vector (3 DOWNTO 0);
        q : OUT std_logic_vector (31 DOWNTO 0));
END COMPONENT;

SIGNAL q1, q2, addin, sum : std_logic_vector (31 DOWNTO 0);
SIGNAL c : std_logic;

BEGIN
PROCESS (aluctrl)
BEGIN
IF (aluctrl <= "0010") OR (aluctrl <= "0001") THEN
         c <= '0';
      ELSIF (aluctrl <= "0110") THEN 
         c <= '1';
      ELSE 
        NULL;
   END IF;
END PROCESS;
U1: inverter PORT MAP (in2, q1);
U2: mux_alu PORT MAP (in2, q1, aluctrl, addin);
U3: orgate PORT MAP (in1, addin, q2);
U4: full_adder_32 PORT MAP (in1, addin, c, sum, cout);
U5: mux_alu1 PORT MAP (sum, q2, aluctrl, alu_result);
END beh_alu_32;

