LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY alu_tb IS
END alu_tb;

ARCHITECTURE beh_alu_tb OF alu_tb IS

COMPONENT alu_32 IS
    PORT (in1, in2 : IN std_logic_vector (31 DOWNTO 0);
          aluctrl : IN std_logic_vector (3 DOWNTO 0);
          alu_result : OUT std_logic_vector (31 DOWNTO 0);
          cout: OUT std_logic);
END COMPONENT;


SIGNAL in1, in2, alu_result: std_logic_vector (31 DOWNTO 0);
SIGNAL aluctrl : std_logic_vector (3 DOWNTO 0);
SIGNAL cout: std_logic;

BEGIN
uut: alu_32 PORT MAP (in1, in2, aluctrl, alu_result, cout);
stim_proc_alu_32: PROCESS
BEGIN



in1 <= "00000000000000000000000000000100";
in2 <= "00000000000000000000000100101100";

aluctrl <= "0010";
WAIT FOR 100 ns;

in1 <= "11011111000101100110110010101101";
in2 <= "11011111000101100110110010101101";

aluctrl <= "0110";
WAIT FOR 100 ns;

in1 <= "11011111000101100110110010101101";
in2 <= "11011111000101100110110010101101";

aluctrl <= "0001";
WAIT FOR 100 ns;

in1 <= "11011111000101100110110010101101";
in2 <= "11011111000101100110110010101101";

aluctrl <= "0000";
WAIT;
END PROCESS;
END;