LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY carry_lookahead_adder IS
    PORT (ina, inb: IN std_logic_vector (3 DOWNTO 0);
         cin: IN std_logic;
         sum: OUT std_logic_vector (3 DOWNTO 0);
         cout: OUT std_logic);
END carry_lookahead_adder;

ARCHITECTURE beh_carry_lookahead_adder of carry_lookahead_adder IS
   SIGNAL c: std_logic_vector (4 DOWNTO 0);
   SIGNAL P: std_logic_vector (3 DOWNTO 0);
   SIGNAL G: std_logic_vector (3 DOWNTO 0);
BEGIN
   G1: FOR i IN 0 TO 3 GENERATE
      p(i) <= ina(i) XOR inb(i);
      g(i) <= ina(i) AND inb(i);
      sum(i) <= p(i) XOR c(i);
END GENERATE;
c(0) <= cin;
c(1) <= (cin AND p(0)) OR
          g(0);
c(2) <= (cin AND p(0) AND p(1)) OR
        (g(0) AND p(1)) OR
         g(1);
c(3) <= (cin AND p(0) AND p(1) AND p(2)) OR
        (g(0) AND p(1) AND p(2)) OR
        (g(1) AND p(2)) OR
         g(2);
c(4) <= (cin AND p(0) AND p(1) AND p(2) AND p(3)) OR
        (g(0) AND p(1) AND p(2) AND p(3)) OR
        (g(1) AND p(2) AND p(3)) OR
        (g(2) AND p(3)) OR
         g(3);
cout <= c(4);
END beh_carry_lookahead_adder;