LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY cla_adder_tb IS
END cla_adder_tb;

ARCHITECTURE beh_cla_adder_tb OF cla_adder_tb IS

COMPONENT carry_lookahead_adder IS
    PORT (ina, inb: IN std_logic_vector (3 DOWNTO 0);
         cin: IN std_logic;
         sum: OUT std_logic_vector (3 DOWNTO 0);
         cout: OUT std_logic);
END COMPONENT;

SIGNAL ina, inb, sum: std_logic_vector (3 DOWNTO 0);
SIGNAL cin, cout: std_logic;

BEGIN
uut: carry_lookahead_adder PORT MAP(
ina => ina,
inb => inb,
sum => sum,
cin => cin,
cout => cout
);

stim_proc_carry_lookahead_adder: PROCESS
BEGIN
WAIT FOR 100 ns;

ina <= "0100";
inb <= "1100";
cin <= '0';
WAIT FOR 100 ns;

ina <= "1101";
inb <= "1100";
cin <= '1';

WAIT;
END PROCESS;
END;