LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY full_adder_tb IS
END full_adder_tb;

ARCHITECTURE beh_full_adder_tb OF full_adder_tb IS

COMPONENT full_adder_32 IS
    PORT (in1, in2: IN std_logic_vector (31 DOWNTO 0);
         cin: IN std_logic;
         sum: OUT std_logic_vector (31 DOWNTO 0);
         cout: OUT std_logic);
END COMPONENT;

SIGNAL in1, in2, sum: std_logic_vector (31 DOWNTO 0);
SIGNAL cin, cout: std_logic;

BEGIN
uut: full_adder_32 PORT MAP(
in1 => in1,
in2 => in2,
sum => sum,
cin => cin,
cout => cout
);

stim_proc_full_adder: PROCESS
BEGIN
WAIT FOR 100 ns;

in1 <= "11011111000101100110110010101101";
in2 <= "11011111000101100110110010101101";
cin <= '0';
WAIT FOR 100 ns;

in1 <= "11011111000101100110110101011011";
in2 <= "11011111000101100110110010101101";
cin <= '1';

WAIT;
END PROCESS;
END;
