LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY ir_tb IS
END ir_tb;

ARCHITECTURE beh_ir_tb OF ir_tb IS
COMPONENT ir IS
   PORT (ir_in: IN std_logic_vector (31 DOWNTO 0);
        IRWrite: IN std_logic;
        instruction_1: OUT std_logic_vector (5 DOWNTO 0);
        instruction_2: OUT std_logic_vector (4 DOWNTO 0);
        instruction_3: OUT std_logic_vector (4 DOWNTO 0);
        instruction_4: OUT std_logic_vector (15 DOWNTO 0));
END COMPONENT;

SIGNAL IRWrite : std_logic;
SIGNAL ir_in : std_logic_vector(31 downto 0);
SIGNAL instruction_1 : std_logic_vector (5 DOWNTO 0);
SIGNAL instruction_2, instruction_3 : std_logic_vector (4 DOWNTO 0);
SIGNAL instruction_4 : std_logic_vector (15 DOWNTO 0);

BEGIN
uut: ir PORT MAP (ir_in, IRWrite, instruction_1, instruction_2, instruction_3, instruction_4);
stim_proc_ir : PROCESS
BEGIN
WAIT FOR 100 ns;
IRWrite <= '1';
ir_in <= "00000000000000000000000000000000";
wait;
END PROCESS;
END beh_ir_tb;
