LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY mem_tb IS
END mem_tb;

ARCHITECTURE beh_mem_tb OF mem_tb IS
COMPONENT mem IS
   PORT (MemRead, MemWrite: IN std_logic;
         address, data_in : IN std_logic_vector(31 downto 0);
         data_out : OUT std_logic_vector (31 DOWNTO 0));
END COMPONENT;

SIGNAL MemRead, MemWrite: std_logic;
SIGNAL address, data_out, data_in : std_logic_vector(31 downto 0);
BEGIN
uut: mem PORT MAP (MemRead, MemWrite, address, data_in, data_out);
stim_proc_mem : PROCESS
BEGIN
WAIT FOR 100 ns;
MemWrite <= '0';
MemRead <= '1';
address <= "00000000000000000000000000000000";
data_in <= "00000000000000000000000000000000";
WAIT FOR 100 ns;
MemWrite <= '0';
MemRead <= '1';
address <= "00000000000000000000000011111111";
data_in <= "00000000000000000000000000000000";
WAIT FOR 100 ns;
MemWrite <= '1';
MemRead <= '0';
address <= "00000000000000000000000011111111";
data_in <= "00000000000000000000000000000000";
WAIT FOR 100 ns;
MemWrite <= '0';
MemRead <= '1';
wait;
END PROCESS;
END beh_mem_tb;
