LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY mem IS
  PORT (MemRead, MemWrite: IN std_logic;
        address, data_in : IN std_logic_vector(31 downto 0);
        data_out : OUT std_logic_vector (31 DOWNTO 0));
END mem;

ARCHITECTURE beh_mem OF mem IS
  TYPE vector_array IS ARRAY (0 TO 2**20-1) OF
    std_logic_vector (31 DOWNTO 0);
  SIGNAL memory : vector_array;
BEGIN
  PROCESS (MemRead, MemWrite, address, data_in)
   BEGIN
     IF (MemWrite = '1') THEN
        memory(CONV_INTEGER(address)) <= data_in;
     END IF; 
     IF (MemRead = '1') THEN
       data_out <= memory(CONV_INTEGER(address));
     ELSE
       data_out <= "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
     END IF;                   
   END PROCESS;
 
END beh_mem; 
