LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY mips IS
  PORT (PC_ctrl, IorD, MemRead, MemWrite, IRWrite, MemtoReg, RegDst, RegWrite, ALUSrcA, rst_bar : IN std_logic;
        ALUSrcB, PCSourse : IN std_logic_vector (1 DOWNTO 0);
        aluctrl : IN std_logic_vector (3 DOWNTO 0));
END mips;

ARCHITECTURE beh_mips OF mips IS
  COMPONENT program_counter IS
   PORT (PC_in : IN std_logic_vector (31 DOWNTO 0); 
	 PC_ctrl, rst_bar : IN std_logic;
	 PC_out: OUT std_logic_vector(31 DOWNTO 0));
  END COMPONENT;

  COMPONENT mem IS
   PORT (MemRead, MemWrite: IN std_logic;
        address, data_in : IN std_logic_vector(31 downto 0);
        data_out : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT ir IS
   PORT (ir_in: IN std_logic_vector (31 DOWNTO 0);
        IRWrite: IN std_logic;
        instruction_1: OUT std_logic_vector (5 DOWNTO 0);
        instruction_2: OUT std_logic_vector (4 DOWNTO 0);
        instruction_3: OUT std_logic_vector (4 DOWNTO 0);
        instruction_4: OUT std_logic_vector (15 DOWNTO 0));
  END COMPONENT;

  COMPONENT mdr IS
   PORT (memdatain: IN std_logic_vector (31 DOWNTO 0);
         memdataout: OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT registers IS
   PORT (read_register1, read_register2, write_register : IN std_logic_vector (4 DOWNTO 0);
         write_data : IN std_logic_vector (31 DOWNTO 0);
         RegWrite : IN std_logic;
         read_data1, read_data2 : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT opa IS
   PORT (datain: IN std_logic_vector (31 DOWNTO 0);
         dataout: OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT opb IS
   PORT (datain: IN std_logic_vector (31 DOWNTO 0);
         dataout: OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT ALU_32 IS
   PORT (in1, in2 : IN std_logic_vector (31 DOWNTO 0);
         aluctrl : IN std_logic_vector (3 DOWNTO 0);
         alu_result : OUT std_logic_vector (31 DOWNTO 0);
         cout: OUT std_logic);
  END COMPONENT;

  COMPONENT alu_out IS
   PORT (datain: IN std_logic_vector (31 DOWNTO 0);
         dataout: OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT mux_1 IS
   PORT (in0, in1 : IN std_logic_vector (31 DOWNTO 0);
         IorD : IN std_logic;
         q : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT mux_2 IS
   PORT (in0, in1 : IN std_logic_vector (31 DOWNTO 0);
         ALUSrcA : IN std_logic;
         q : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT mux_3 IS
   PORT (in0, in1 : IN std_logic_vector (4 DOWNTO 0);
         RegDst : IN std_logic;
         q : OUT std_logic_vector (4 DOWNTO 0));
  END COMPONENT;

  COMPONENT mux_4 IS
   PORT (in0, in1 : IN std_logic_vector (31 DOWNTO 0);
         MemtoReg : IN std_logic;
         q : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT mux_5 IS
   PORT (in0, in1, in2, in3 : IN std_logic_vector (31 DOWNTO 0);
         ALUSrcB : IN std_logic_vector (1 DOWNTO 0);
         q : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT mux_6 IS
   PORT (in0, in1, in2 : IN std_logic_vector (31 DOWNTO 0);
         PCSourse : IN std_logic_vector (1 DOWNTO 0);
         q : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT sign_extend IS
   PORT (sign_extend_in : IN std_logic_vector (15 DOWNTO 0);
         sign_extend_out : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT shift_left_2 IS 
   PORT (sll_in : IN std_logic_vector (31 DOWNTO 0);
         sll_out : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;

  COMPONENT shift_left_2_1 IS 
   PORT (sll_in : IN std_logic_vector (25 DOWNTO 0);
         sll_out : OUT std_logic_vector (27 DOWNTO 0));
  END COMPONENT;
SIGNAL pcout, mux2, mux4, mux5, mux6, memdata, readdata1, readdata2, a, b, i4_ex, i4_ex_sll, four, alu_result, aluout, mdrout, jump_address: std_logic_vector (31 DOWNTO 0);
SIGNAL i1 : std_logic_vector (5 DOWNTO 0);
SIGNAL i2, i3, i4_1, mux3 : std_logic_vector (4 DOWNTO 0);
SIGNAL i4 : std_logic_vector (15 DOWNTO 0);
SIGNAL i5 : std_logic_vector (25 DOWNTO 0);
SIGNAL i5_ex : std_logic_vector (27 DOWNTO 0); 
SIGNAL pc_1 : std_logic_vector (3 DOWNTO 0);
SIGNAL mux1 : std_logic_vector (31 DOWNTO 0);
SIGNAL cout : std_logic;
BEGIN
four  <= "00000000000000000000000000000100";
U1: program_counter PORT MAP (mux6, PC_ctrl, rst_bar, pcout);
U2: mux_1 PORT MAP (pcout, aluout, IorD, mux1);
U3: mem PORT MAP (MemRead, MemWrite, mux1, b, memdata);
U4: ir PORT MAP (memdata, IRWrite, i1, i2, i3, i4);
i4_1 (4 DOWNTO 0) <= i4 (15 DOWNTO 11);
U5: mux_3 PORT MAP (i3, i4_1, RegDst, mux3);
U6: mdr PORT MAP (memdata, mdrout);
U7: mux_4 PORT MAP (aluout, mdrout, MemtoReg, mux4);
U8: registers PORT MAP (i2, i3, mux3, mux4, RegWrite, readdata1, readdata2);
U9: sign_extend PORT MAP (i4, i4_ex);
U10: shift_left_2 PORT MAP (i4_ex, i4_ex_sll);
i5 (25 DOWNTO 21) <= i2;
i5 (20 DOWNTO 16) <= i3;
i5 (15 DOWNTO 0) <= i4;
U11: shift_left_2_1 PORT MAP (i5, i5_ex);
U12: opa PORT MAP (readdata1, a);
U13: opb PORT MAP (readdata2, b);
U14: mux_2 PORT MAP (pcout, a, ALUSrcA, mux2);
U15: mux_5 PORT MAP (b, four, i4_ex, i4_ex_sll, ALUSrcB, mux5);
U16: ALU_32 PORT MAP (mux2, mux5, aluctrl, alu_result, cout);
U17: alu_out PORT MAP (alu_result, aluout);
jump_address (31 DOWNTO 28) <= pcout (31 DOWNTO 28);
jump_address (27 DOWNTO 0) <= i5_ex (27 DOWNTO 0);
U18: mux_6 PORT MAP(alu_result, aluout, jump_address, PCSourse, mux6);
END beh_mips;