LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY mips_tb IS
END mips_tb;

ARCHITECTURE beh_mips_tb OF mips_tb IS

COMPONENT mips IS
   PORT (PC_ctrl, IorD, MemRead, MemWrite, IRWrite, MemtoReg, RegDst, RegWrite, ALUSrcA, rst_bar : IN std_logic;
         ALUSrcB, PCSourse : IN std_logic_vector (1 DOWNTO 0);
         aluctrl : IN std_logic_vector (3 DOWNTO 0));
END COMPONENT;
SIGNAL PC_ctrl, IorD, MemRead, MemWrite, IRWrite, MemtoReg, RegDst, RegWrite, ALUSrcA, rst_bar, sel : std_logic;
SIGNAL ALUSrcB, PCSourse : std_logic_vector (1 DOWNTO 0);
SIGNAL aluctrl : std_logic_vector (3 DOWNTO 0);

BEGIN

uut: mips PORT MAP (PC_ctrl => PC_ctrl, IorD => IorD, MemRead => MemRead, MemWrite => MemWrite, IRWrite => IRWrite, MemtoReg => MemtoReg, RegDst => RegDst, RegWrite => RegWrite, ALUSrcA => ALUSrcA, ALUSrcB => ALUSrcB, PCSourse => PCSourse, aluctrl => aluctrl, rst_bar => rst_bar);

stim_proc_mips : PROCESS
BEGIN
WAIT FOR 100 ns;
-- lw
-- 1st
IorD <= '0'; MemRead <= '1'; MemWrite <= '0'; ALUSrcA <= '0';  ALUSrcB <= "01"; aluctrl <= "0010"; PC_ctrl <= '0'; rst_bar <= '0'; 
WAIT FOR 1 ns;
PCSourse <= "00";
WAIT FOR 100 ns;
--2nd
IRWrite <= '1'; ALUSrcA <= '0'; ALUSrcB <= "11"; aluctrl <= "0010"; PC_ctrl <= '1'; rst_bar <= '1'; MemRead <= '0';
WAIT FOR 100 ns;
--3rd
ALUSrcA <= '1'; ALUSrcB <= "10"; aluctrl <= "0010"; IRWrite <= '0'; PC_ctrl <= '0';
WAIT FOR 100 ns;
--4th
IorD <= '1';
MemRead <= '1'; MemWrite <= '0'; 
WAIT FOR 100 ns;
--5th
MemtoReg <= '1';  RegDst <= '0';
WAIT FOR 1 ns;
RegWrite <= '1';
WAIT FOR 100 ns;
--sw
--1st
IorD <= '0'; MemRead <= '1'; MemWrite <= '0'; ALUSrcA <= '0';  ALUSrcB <= "01"; aluctrl <= "0010"; RegWrite <= '0'; PCSourse <= "01";
WAIT FOR 1 ns;
PCSourse <= "00";
WAIT FOR 100 ns;
--2nd
IRWrite <= '1'; ALUSrcA <= '0'; ALUSrcB <= "11"; aluctrl <= "0010"; PC_ctrl <= '1'; MemRead <= '0'; 
WAIT FOR 100 ns;
--3rd
ALUSrcA <= '1'; ALUSrcB <= "10"; aluctrl <= "0010"; IRWrite <= '0'; PC_ctrl <= '0';
WAIT FOR 100 ns;
--4th
IorD <= '1';
WAIT FOR 1 ns;
MemRead <= '0'; MemWrite <= '1';
WAIT FOR 100 ns;
--add
--1st
IorD <= '0'; MemRead <= '1'; MemWrite <= '0'; ALUSrcA <= '0';  ALUSrcB <= "01"; aluctrl <= "0010"; PCSourse <= "01";
WAIT FOR 1 ns;
PCSourse <= "00";
WAIT FOR 100 ns;
--2nd
IRWrite <= '1'; ALUSrcA <= '0'; ALUSrcB <= "11"; aluctrl <= "0010"; PC_ctrl <= '1'; MemRead <= '0';
WAIT FOR 100 ns;
--3rd
ALUSrcA <= '1'; ALUSrcB <= "00"; aluctrl <= "0010"; IRWrite <= '0'; PC_ctrl <= '0';
WAIT FOR 100 ns;
--4th
MemtoReg <= '0';  RegDst <= '1';
WAIT FOR 1 ns;
RegWrite <= '1';
WAIT FOR 100 ns;
--beq
--1st
IorD <= '0'; MemRead <= '1'; MemWrite <= '0'; ALUSrcA <= '0';  ALUSrcB <= "01"; aluctrl <= "0010"; PCSourse <= "01";
WAIT FOR 1 ns;
PCSourse <= "00";
WAIT FOR 100 ns;
--2nd
IRWrite <= '1'; ALUSrcA <= '0'; ALUSrcB <= "11"; aluctrl <= "0010"; PC_ctrl <= '1'; MemRead <= '0';
WAIT FOR 100 ns;
--3rd
ALUSrcA <= '1'; ALUSrcB <= "00"; aluctrl <= "0110"; IRWrite <= '0'; PC_ctrl <= '0'; PCSourse <= "01";
WAIT FOR 100 ns;
--subi
--1st
IorD <= '0'; MemRead <= '1'; MemWrite <= '0'; ALUSrcA <= '0';  ALUSrcB <= "01"; aluctrl <= "0010"; RegWrite <= '0'; 
WAIT FOR 1 ns;
PCSourse <= "00";
WAIT FOR 100 ns;
--2nd
IRWrite <= '1'; ALUSrcA <= '0'; ALUSrcB <= "11"; aluctrl <= "0010"; PC_ctrl <= '1'; MemRead <= '0';
WAIT FOR 100 ns;
--3rd
ALUSrcA <= '1'; ALUSrcB <= "10"; aluctrl <= "0110"; IRWrite <= '0'; PC_ctrl <= '0';
WAIT FOR 100 ns;
--4th
MemtoReg <= '0';  RegDst <= '0';
WAIT FOR 1 ns;
RegWrite <= '1';
--ori
--1st
IorD <= '0'; MemRead <= '1'; MemWrite <= '0'; ALUSrcA <= '0';  ALUSrcB <= "01"; aluctrl <= "0010"; RegWrite <= '0'; PCSourse <= "01";
WAIT FOR 1 ns;
PCSourse <= "00";
WAIT FOR 100 ns;
--2nd
IRWrite <= '1'; ALUSrcA <= '0'; ALUSrcB <= "11"; aluctrl <= "0010"; PC_ctrl <= '1'; MemRead <= '0';
WAIT FOR 100 ns;
--3rd
ALUSrcA <= '1'; ALUSrcB <= "10"; aluctrl <= "0001"; IRWrite <= '0'; PC_ctrl <= '0';
WAIT FOR 100 ns;
--4th
MemtoReg <= '0';  RegDst <= '0';
WAIT FOR 1 ns;
RegWrite <= '1';
WAIT;
END PROCESS;
END beh_mips_tb;

