LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY registers_tb IS
END registers_tb;

ARCHITECTURE beh_registers_tb OF registers_tb IS
  COMPONENT registers IS
     PORT (read_register1, read_register2, write_register : IN std_logic_vector (4 DOWNTO 0);
           write_data : IN std_logic_vector (31 DOWNTO 0);
           RegWrite : IN std_logic;
           read_data1, read_data2 : OUT std_logic_vector (31 DOWNTO 0));
  END COMPONENT;
SIGNAL RegWrite : std_logic;
SIGNAL read_data1, read_data2, write_data : std_logic_vector (31 DOWNTO 0);
SIGNAL read_register1, read_register2, write_register : std_logic_vector (4 DOWNTO 0);
BEGIN

uut: registers PORT MAP (read_register1, read_register2, write_register, write_data, RegWrite, read_data1, read_data2);
stim_proc_registers : PROCESS
BEGIN
WAIT FOR 100 ns;
read_register1 <= "00001";
read_register2 <= "00011";
write_register <= "00011";
write_data <= "11111111111111111111111111111111";
WAIT FOR 1 ns;
RegWrite <= '1';
wait;
END PROCESS;
END beh_registers_tb;