LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

ENTITY registers IS
   PORT (read_register1, read_register2, write_register : IN std_logic_vector (4 DOWNTO 0);
         write_data : IN std_logic_vector (31 DOWNTO 0);
         RegWrite : IN std_logic;
         read_data1, read_data2 : OUT std_logic_vector (31 DOWNTO 0));
END registers;

ARCHITECTURE beh_registers OF registers IS

TYPE register_file IS ARRAY (0 TO 31) OF STD_LOGIC_VECTOR (31 DOWNTO 0);
SIGNAL register_array : register_file;
SIGNAL read_register_address1 : std_logic_vector (4 DOWNTO 0);
SIGNAL read_register_address2 : std_logic_vector (4 DOWNTO 0);
SIGNAL write_register_address : std_logic_vector (4 DOWNTO 0);
BEGIN
  read_register_address1 <= read_register1;
  read_register_address2 <= read_register2;
  read_data1 <= register_array(CONV_INTEGER(read_register_address1));
  read_data2 <= register_array(CONV_INTEGER(read_register_address2));
  write_register_address <= write_register;
PROCESS (RegWrite)
 BEGIN
  IF (RegWrite = '1') THEN
  register_array(CONV_INTEGER(write_register_address)) <= write_data;
  END IF;
END PROCESS;
END beh_registers;