﻿'Project:       Sprint2
'Programmers:   Glenn Cummings
'               
'               
' ******          Tasks Completed --- 2,3     *******
'               
'Date:          April 2011
'Decription:    This program allows the pc user to select two airport hub IDs from an array,
'               display the location, latitude and longitude of those airports,
'               and calculate the shortest distance between those airports in miles.
'
Option Strict On
Option Explicit On
Imports System.Math
Public Class Airports

    Public Enum FieldNames
        ID = 0
        City = 1
        Lat = 2
        Lon = 3
    End Enum

    Structure Airport 'Record
        Dim ID As String
        Dim City As String
        Dim Lat As String
        Dim Lon As String
    End Structure

    'Internal variables for current Airport records
    Dim Index1Integer As Integer
    Dim Lat1Double As Double
    Dim Lon1Double As Double
    Dim Index2Integer As Integer
    Dim Lat2Double As Double
    Dim Lon2Double As Double

    'Array of all Airport records
    Dim Hubs(3) As Airport

    Private Sub Airports_Load(ByVal sender As Object, _
                ByVal e As System.EventArgs) Handles Me.Load

        'Load small sample of airport hubs into Hubs array
        Hubs(0).ID = "ATL"
        Hubs(0).City = "Atlanta"
        Hubs(0).Lat = "33° 38' 22"" N"
        Hubs(0).Lon = "84° 25' 41"" W"
        Hubs(1).ID = "BOS"
        Hubs(1).City = "Boston"
        Hubs(1).Lat = "42° 21' 42"" N"
        Hubs(1).Lon = "71° 0' 42"" W"
        Hubs(2).ID = "CLE"
        Hubs(2).City = "Cleveland"
        Hubs(2).Lat = "41° 24' 27"" N"
        Hubs(2).Lon = "81° 51' 4"" W"
        Hubs(3).ID = "DEN"
        Hubs(3).City = "Denver"
        Hubs(3).Lat = "39° 51' 12"" N"
        Hubs(3).Lon = "104° 40' 32"" W"

        'Load ID1ComboBox List
        For IndexInteger As Integer = 0 To 3
            ID1ComboBox.Items.Add(Hubs(IndexInteger).ID)
        Next

        'Load ID2ComboBox List
        For IndexInteger As Integer = 0 To 3
            ID2ComboBox.Items.Add(Hubs(IndexInteger).ID)
        Next

    End Sub

    Public Function CoordinateToDegrees(ByVal DegreeString As String) As Double

    End Function

    '************  Task 2 Degrees to radian function ********************
    Public Function DegreesToRadians(ByVal DegreesDouble As Double) As Double
        Dim Radians As Double
        Radians = DegreesDouble * PI / 180.0
        Return Radians
    End Function

    '***********    Task 3 Index into string function   **************
    Public Function ValueOf(ByVal Index As Integer, ByVal FieldName As FieldNames) As String
        If (FieldName = FieldName.City) Then
            Return Hubs(Index).City
        ElseIf (FieldName = FieldName.Lat) Then
            Return Hubs(Index).Lat
        Else
            Return Hubs(Index).Lon
        End If
    End Function

    Public Function Distance(ByVal Index1 As Integer, ByVal Index2 As Integer) As Double

    End Function

    Private Sub ID1ComboBox_SelectedIndexChanged(ByVal sender As System.Object, _
                ByVal e As System.EventArgs) Handles ID1ComboBox.SelectedIndexChanged
        '
        'Load Cit1TextBox, Lat1TextBox, Lon1TextBox with values from the array Airports(ID1Integer)
        '
        Index1Integer = ID1ComboBox.SelectedIndex
        City1TextBox.Text = Hubs(Index1Integer).City
        Lat1TextBox.Text = Hubs(Index1Integer).Lat
        Lon1TextBox.Text = Hubs(Index1Integer).Lon
    End Sub

    Private Sub ID2ComboBox_SelectedIndexChanged(ByVal sender As System.Object, _
                ByVal e As System.EventArgs) Handles ID2ComboBox.SelectedIndexChanged
        '
        'Load Cit2TextBox, Lat2TextBox, Lon2TextBox with values from the array Airports(ID2Integer)
        '
        Index2Integer = ID2ComboBox.SelectedIndex
        City2TextBox.Text = Hubs(Index2Integer).City
        Lat2TextBox.Text = Hubs(Index2Integer).Lat
        Lon2TextBox.Text = Hubs(Index2Integer).Lon
    End Sub


    Private Sub Calc1Button_Click(ByVal sender As System.Object, _
                ByVal e As System.EventArgs) Handles Calc1Button.Click
        '
        ' Convert the Latitude and Longitude to Fractional Degrees
        '
        Dim degrees As Double
        Dim minutes As Double
        Dim seconds As Double
        Dim StartPtr, StopPtr As Integer
        StartPtr = 0
        StopPtr = Hubs(Index1Integer).Lat.IndexOf("°", StartPtr)
        degrees = Convert.ToDouble(Hubs(Index1Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(Index1Integer).Lat.IndexOf("'", StartPtr)
        minutes = Convert.ToDouble(Hubs(Index1Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(Index1Integer).Lat.IndexOf("""", StartPtr)
        seconds = Convert.ToDouble(Hubs(Index1Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        '1 degree = 60 minutes = 3600 seconds
        '1 minute = 60 seconds
        Lat1Double = degrees + minutes / 60.0 + seconds / 3600.0
        Lat1TextBox.Text = Lat1Double.ToString("F5")
        StartPtr = 0
        StopPtr = Hubs(Index1Integer).Lon.IndexOf("°", StartPtr)
        degrees = Convert.ToDouble(Hubs(Index1Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(Index1Integer).Lon.IndexOf("'", StartPtr)
        minutes = Convert.ToDouble(Hubs(Index1Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(Index1Integer).Lon.IndexOf("""", StartPtr)
        seconds = Convert.ToDouble(Hubs(Index1Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        '1 degree = 60 minutes = 3600 seconds
        '1 minute = 60 seconds
        Lon1Double = degrees + minutes / 60.0 + seconds / 3600.0
        Lon1TextBox.Text = Lon1Double.ToString("F5")
    End Sub

    Private Sub Calc2Button_Click(ByVal sender As System.Object, _
                ByVal e As System.EventArgs) Handles Calc2Button.Click
        '
        ' Convert the Latitude and Longitude to Fractional Degrees
        '
        Dim degrees As Double
        Dim minutes As Double
        Dim seconds As Double
        Dim StartPtr, StopPtr As Integer
        StartPtr = 0
        StopPtr = Hubs(Index2Integer).Lat.IndexOf("°", StartPtr)
        degrees = Convert.ToDouble(Hubs(Index2Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(Index2Integer).Lat.IndexOf("'", StartPtr)
        minutes = Convert.ToDouble(Hubs(Index2Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(Index2Integer).Lat.IndexOf("""", StartPtr)
        seconds = Convert.ToDouble(Hubs(Index2Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        Lat2Double = degrees + minutes / 60.0 + seconds / 3600.0
        Lat2TextBox.Text = Lat2Double.ToString("F5")
        StartPtr = 0
        StopPtr = Hubs(Index2Integer).Lon.IndexOf("°", StartPtr)
        degrees = Convert.ToDouble(Hubs(Index2Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(Index2Integer).Lon.IndexOf("'", StartPtr)
        minutes = Convert.ToDouble(Hubs(Index2Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(Index2Integer).Lon.IndexOf("""", StartPtr)
        seconds = Convert.ToDouble(Hubs(Index2Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        Lon2Double = degrees + minutes / 60.0 + seconds / 3600.0
        Lon2TextBox.Text = Lon2Double.ToString("F5")

    End Sub

    Private Sub CalcDistanceButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CalcDistanceButton.Click
        '
        'Calculate the distance in miles between the two cities selected in the combo boxes after their latitudes and longitudes
        'have been converted to decimal fractions
        '
        Const R As Double = 3958.761 'mean Earth radius in miles
        Dim Lat1, Lat2, Lon1, Lon2 As Double
        'Convert angles to radians
        '180 degrees = Pi radians
        Lat1 = Lat1Double * PI / 180.0
        Lat2 = Lat2Double * PI / 180.0
        Lon1 = Lon1Double * PI / 180.0
        Lon2 = Lon2Double * PI / 180.0
        'Spherical law of cosines: 	
        'Anton von Braunmühl, Vorlesungen über Geschichte der Trigonometrie, Vol. 1, 1900
        'd = acos(sin(lat1) • sin(lat2) + cos(lat1) • cos(lat2) • cos(long2 − long1)) • R
        DistanceTextBox.Text = (Acos(Sin(Lat1) * Sin(Lat2) + Cos(Lat1) * Cos(Lat2) * Cos(Lon2 - Lon1)) * R).ToString("F0")
    End Sub
End Class


