﻿'Project:       Sprint1
'Programmers:   Glenn Cummings
'               
'               
'               
'               
'Date:          April 2011
'Decription:    This program allows the pc user to select two hub airports IDs from an array,
'               display the location, latitude and longitude of those airports,
'               and calculate the shortest distance between those airports in miles.
'
Option Strict On
Option Explicit On
Imports System.Math
Public Class Airports

    Structure Airport 'Record
        Dim ID As String
        Dim City As String
        Dim Lat As String
        Dim Lon As String
    End Structure

    'Internal variables for current Airport records
    Dim ID1Integer As Integer
    Dim Lat1Double As Double
    Dim Lon1Double As Double
    Dim ID2Integer As Integer
    Dim Lat2Double As Double
    Dim Lon2Double As Double

    'Array of all Airport records
    Dim Hubs(2) As Airport

    Private Sub Airports_Load(ByVal sender As Object, _
                ByVal e As System.EventArgs) Handles Me.Load

        'Load small sample of airport hubs into Hubs array
        Hubs(0).ID = "ATL"
        Hubs(0).City = "Atlanta"
        Hubs(0).Lat = "33° 38' 22"" N"
        Hubs(0).Lon = "84° 25' 41"" W"
        Hubs(1).ID = "BOS"
        Hubs(1).City = "Boston"
        Hubs(1).Lat = "42° 21' 42"" N"
        Hubs(1).Lon = "71° 0' 42"" W"
        Hubs(2).ID = "CLE"
        Hubs(2).City = "Cleveland"
        Hubs(2).Lat = "41° 24' 27"" N"
        Hubs(2).Lon = "81° 51' 4"" W"
        'Load ID1ComboBox List
        For IndexInteger As Integer = 0 To 2
            ID1ComboBox.Items.Add(Hubs(IndexInteger).ID)
        Next

        'Load ID2ComboBox List
        For IndexInteger As Integer = 0 To 2
            ID2ComboBox.Items.Add(Hubs(IndexInteger).ID)
        Next

    End Sub

    Private Sub ID1ComboBox_SelectedIndexChanged(ByVal sender As System.Object, _
                ByVal e As System.EventArgs) Handles ID2ComboBox.SelectedIndexChanged
        IDInteger = ID1ComboBox.SelectedIndex
        CityTextBox.Text = Hubs(ID1Integer).City
        Lat1TextBox.Text = Hubs(ID1Integer)..Lat
        Lon1TextBox.Text = Hubs(ID1Integer).Long
    End Sub

    Private Sub ID2ComboBox_SelectedIndexChanged(ByVal sender As System.Object, _
                ByVal e As System.EventArgs) Handles ID1ComboBox.SelectedIndexChanged
        IDInteger = ID2ComboBox.SelectedIndex
        CityTextBox.Text = Hubs(ID2Integer).City
        Lat2TextBox.Text = Hubs(ID2Integer)..Lat
        Lon2TextBox.Text = Hubs(ID2Integer).Long
    End Sub


    Private Sub Calc1Button_Click(ByVal sender As System.Object, _
                ByVal e As System.EventArgs) Handles Calc1Button.Click
        Dim degrees As Double
        Dim minutes As Double
        Dim seconds As Double
        Dim StartPtr, StopPtr As Integer
        StartPtr = 0
        StopPtr = Hubs(ID2Integer).Lat.IndexOf("°", StartPtr)
        degrees = Convert.ToDouble(Hubs(ID1Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(ID1Integer).Lat.IndexOf("'", StartPtr)
        minutes = Convert.ToDouble(Hubs(ID1Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(ID1Integer).Lat.IndexOf(""", StartPtr)
        seconds = Convert.ToDouble(Hubs(ID1Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        '1 degree = 60 minutes
        '1 minute = 60 seconds
        Lat1Double = degrees + minutes / 60.0 + seconds / 360.0
        Lat1TextBox.Text = Lat1Double.ToString("F5")
        StartPtr = 0
        StopPtr = Hubs(ID2Integer).Long.IndexOf("°", StartPtr)
        degrees = Convert.ToDouble(Hubs(ID1Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(ID1Integer).Long.IndexOf("'", StartPtr)
        minutes = Convert.ToDouble(Hubs(ID1Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(ID1Integer).Long.IndexOf(""", StartPtr)
        seconds = Convert.ToDouble(Hubs(ID1Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        '1 degree = 60 minutes
        '1 minute = 60 seconds
        Lon1Double = degrees + minutes / 60.0 + seconds / 360.0
        Lon1TextBox.Text = Lon1Double.ToString("F5")
    End Sub

    Private Sub Calc2Button_Click(ByVal sender As System.Object, _
                ByVal e As System.EventArgs) Handles Calc2Button.Click
        Dim degrees As Double
        Dim minutes As Double
        Dim seconds As Double
        Dim StartPtr, StopPtr As Integer
        StartPtr = 0
        StopPtr = Hubs(ID1Integer).Lat.IndexOf("°", StartPtr)
        degrees = Convert.ToDouble(Hubs(ID2Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(ID2Integer).Lat.IndexOf("'", StartPtr)
        minutes = Convert.ToDouble(Hubs(ID2Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(ID2Integer).Lat.IndexOf(""", StartPtr)
        seconds = Convert.ToDouble(Hubs(ID2Integer).Lat.Substring(StartPtr, StopPtr - StartPtr))
        '1 degree = 60 minutes
        '1 minute = 60 seconds
        Lat2Double = degrees + minutes / 60.0 + seconds / 360.0
        Lat2TextBox.Text = Lat2Double.ToString("F5")
        StartPtr = 0
        StopPtr = Hubs(ID1Integer).Long.IndexOf("°", StartPtr)
        degrees = Convert.ToDouble(Hubs(ID2Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(ID2Integer).Long.IndexOf("'", StartPtr)
        minutes = Convert.ToDouble(Hubs(ID2Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        StopPtr = Hubs(ID2Integer).Long.IndexOf(""", StartPtr)
        seconds = Convert.ToDouble(Hubs(ID2Integer).Lon.Substring(StartPtr, StopPtr - StartPtr))
        StartPtr = StopPtr + 1
        '1 degree = 60 minutes
        '1 minute = 60 seconds
        Lon2Double = degrees + minutes / 60.0 + seconds / 360.0
        Lon2TextBox.Text = Lon2Double.ToString("F5")

    End Sub

    Private Sub CalcDistanceButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CalcDistanceButton.Click
        Const R As Double = 3958.761 'mean Earth radius in miles
        Dim Lat1, Lat2, Lon1, Lon2 As Double
        'Convert angles to radians
        '180 degrees = Pi radians
        Lat1 = Lat1Double * PI / 360.0
        Lat2 = Lat2Double * PI / 360.0
        Lon1 = Long1Double * PI / 360.0
        Lon2 = Long2Double * PI / 360.0
        'Spherical law of cosines: 	
        'Anton von Braunmühl, Vorlesungen über Geschichte der Trigonometrie, Vol. 1, 1900
        'd = acos(sin(lat1) • sin(lat2) + cos(lat1) • cos(lat2) • cos(long2 − long1)) • R
        DistanceTextBox.Text = (Acos(Sine(Lat1).Sine(Lat2) + Cos(Lat1).Cos(Lat2).Cos(Long2 - Long1)).R).ToString("F0")
    End Sub
End Class


