#include <iostream>
#include <fstream>

const int MAX_STRING_LENGTH = 50;
const int MAX_NUM_CARS = 10;

struct rentalCar
{
	char make[MAX_STRING_LENGTH];
	char model[MAX_STRING_LENGTH];
	int year;
	float price;
	bool availability;
};

void readFile(char fileName[], rentalCar[]);
void displayCarData(rentalCar cars);
void carEstimate(rentalCar car, int days);
void mostExpensive(rentalCar cars[]);
void availableCars(rentalCar cars[]);
int showMenu();

int main()
{
	char nameOfFile[MAX_STRING_LENGTH];
	int menuChoice;
	bool programOn;
	rentalCar vehicles[MAX_NUM_CARS];


	std::cout << "Enter file name: ";
	std::cin >> nameOfFile;

	readFile(nameOfFile, vehicles);

	do
	{

		menuChoice = showMenu();

		switch (menuChoice)
		{
		case 1:
			for (int i = 0; i < MAX_NUM_CARS; i++)
			{
				std::cout << i + 1 << ") ";
				displayCarData(vehicles[i]);
			}
			programOn = true;
			break;

		case 2:
		{
		  int carNum = 0;
		  int days = 0;

		  std::cout << "Enter car number: ";
		  std::cin >> carNum;
		  std::cout << std::endl;

		  std::cout << "Enter number of days: " ;
		  std::cin >> days;
		  std::cout << std::endl;

		  carNum--;

		  carEstimate(vehicles[carNum], days);
		  programOn = true;
		  break;
		}

		case 3:
			mostExpensive(vehicles);
			programOn = true;
			break;

		case 4:
			availableCars(vehicles);
			programOn = true;
			break;

		default:
			return 0;
			break;
	}
		
	std:: cout << std:: endl << "Press enter to go back to menu." ;
	std:: cin.ignore().get();	
	
	} while (programOn);



}

// reads in file that the user has input
void readFile(char fileName[], rentalCar vehicles[])
{
	std::ifstream fileIn;
	rentalCar read;
	int carCount = 0;

	fileIn.open(fileName);

	while (fileIn >> read.year && carCount < MAX_NUM_CARS)
	{
		fileIn >> read.make;
		fileIn >> read.model;
		fileIn >> read.price;
		fileIn >> read.availability;

		vehicles[carCount] = read;
		carCount++;
	}

}

//displays the data from the car file
void displayCarData(rentalCar cars)
{

	std::cout << cars.year << " "
		<< cars.make << " "
		<< cars.model << " $"
		<< cars.price << " per day "
		<< "Available: ";

	if (cars.availability == true)
	{
		std::cout << "true" << std::endl;
	}
	else
	{
		std::cout << "false" << std::endl;
	}

}

// estimates the cost by which car the user wants multiplied by how many days.
void carEstimate(rentalCar car, int days)
{
	float cost = 0.0;

	cost = car.price * days;

	std::cout << "Estimated cost of renting is: " << cost << std::endl;
}

//loops through the cars to find the most expensive car by price
void mostExpensive(rentalCar cars[])
{
	float max = 0.0;
	int maxCar = 0;

	for (int i = 0; i < 10; i++) {
		if (cars[i].price > max) {
			max = cars[i].price;
			maxCar = i;
		}
	}

	std::cout << "The most expensive car is: "
		<< cars[maxCar].year << " "
		<< cars[maxCar].make << " "
		<< cars[maxCar].model << " $"
		<< cars[maxCar].price << " per day Available: ";
		
		if (cars[maxCar].availability == true)
		{
			std::cout << "true" << std::endl;
		}
		else
		{
			std::cout << "false" << std::endl;
		}
}

// Loops through the cars and finds which cars have the availability as true and prints it.
void availableCars(rentalCar cars[])
{
	for (int i = 0; i < 10; i++)
	{
		if (cars[i].availability == true)
		{
			displayCarData(cars[i]);
		}
	}

}

// Shows the menu for the user, and get the input from what the user wants
int showMenu()
{
	int userInput;

	std::cout << std::endl << " Rental Car Service" << std::endl;
	std::cout << " ==================" << std::endl << std::endl;

	std::cout << "1. Print data for all cars" << std::endl;
	std::cout << "2. Estimate car rental cost" << std::endl;
	std::cout << "3. Find the most expensive car" << std::endl;
	std::cout << "4. Print data for available cars" << std::endl;
	std::cout << "5. Exit program" << std::endl << std::endl;
	std::cout << "Enter selection: ";

	std::cin >> userInput;

	std::cout << std::endl;

	return userInput;
}
