#pragma once

#include "entity.h"

/** [Mob]ile Entity */
class MOB : public Entity
{
	Vector2 velocity; // how much to move per second
	float maxSpeed;   // what to limit speed to
public:
	MOB(){}
	virtual Vector2 getVelocity(){ return velocity; }
	virtual void setVelocity(Vector2 v)
	{
		velocity = v;
		velocity.limitMagnitude(maxSpeed);
	}
	virtual void addVelocity(Vector2 v)
	{
		velocity += v;
		velocity.limitMagnitude(maxSpeed);
	}
	void update(float secondsPassed)
	{
		this->area.center += (velocity * secondsPassed);
	}
	void draw(void* hdc);
	void applyStoppingForce(float force);
	void setMaxSpeed(float maxSpeed){ this->maxSpeed = maxSpeed; }
	float getMaxSpeed(){ return maxSpeed; }
};
