#pragma once

/**
 * Object Oriented implementation of a 2 dimensional (math) vector
 */
struct Vector2
{
	/** the x, y coordinates */
	float x, y;

	/** initializes the Vector2 */
	Vector2(float x, float y):x(x),y(y){}

	/** default constructor - sets x,y to 0,0 */
	Vector2():x(0),y(0){}

	/** @return true if the given x, y coordinate mathes this Vector2's data */
	bool is(float x, float y) const;

	/** @return true if the given x, y coordinate mathes this Vector2's data */
	bool is(Vector2 xy) const ;

	/** @return true if the Vector2 is within the given rectangular boundary */
	bool isWithin(float minx, float miny, float maxx, float maxy);

	/** re-initialize */
	void init(float x, float y);

	/** @return a random Vector2 within the specified boundary */
	static Vector2 random(Vector2 min, Vector2 max);

	/** @return pythagorean distance from the origin */
	float magnitude();

	Vector2 operator+(Vector2 const & v) const;
	Vector2 operator-(Vector2 const & v) const;
	Vector2 operator*(float value) const;
	Vector2 operator/(float value) const;
	Vector2 & operator+=(Vector2& v);
	Vector2 & operator-=(Vector2& v);
	Vector2 & operator*=(float value);
	Vector2 & operator/=(float value);
	bool operator==(Vector2 const & v) const { return is(v); }
	bool operator!=(Vector2 const & v) const { return !is(v); }

	/**
	 * @param A,B line 1
	 * @param C,D line 2
	 * @param point __OUT to the intersection of line AB and CD
	 * @param dist __OUT the distance along line AB to the intersection
	 * @return true if intersection occurs between the lines
	 */
	static bool lineIntersection(const Vector2 & A, const Vector2 & B, 
	                             const Vector2 & C, const Vector2 & D, 
	                             float & dist, Vector2 & point);

	/**
	 * @return positive if v2 is clockwise of this vector
	 * (assume Y points down, X to right)
	 */
	float sign(const Vector2 & v) const;

	/** @return true if this point is inside the given triangle */
	bool isInsideTriangle(Vector2 const & a, Vector2 const & b, 
	                      Vector2 const & c) const;

	void limitMagnitude(float max);
};
