﻿Imports System.IO

Public Class Form1
    Dim IsWasher As Boolean, rowcount As Integer, overalannualcost As Double
    Private Sub btnClear_Click(sender As Object, e As EventArgs) Handles btnClear.Click
        ClearText()
    End Sub
    Sub ClearText()
        txtCost.Text = ""
        txtAvgNumHours.Text = ""
        txtPower.Text = ""
        txtHourCost.Text = ""
        txtAnnualCost.Text = ""
        txtCPG.Text = ""
        txtNGWater.Text = ""
        cbxHomeAppliance.SelectedIndex = 0
        IsWasher = False
    End Sub

    Private Sub btnCalculate_Click(sender As Object, e As EventArgs) Handles btnCalculate.Click
        '      Try
        Dim cost As Double, avgnumhour As Double, power As Double, hourcost As Double, annualcost As Double
        Dim totwatercost As Double, gallonwatercost As Double
        Dim numgallon As Integer, washerflag As Integer
        totwatercost = 0
        washerflag = 0

        If txtCost.Text <> "" And txtAvgNumHours.Text <> "" And txtPower.Text <> "" Then
            cost = Double.Parse(txtCost.Text)
            avgnumhour = Double.Parse(txtAvgNumHours.Text)
            power = Double.Parse(txtPower.Text)
            If cbxHomeAppliance.SelectedIndex > 0 Then
                If cost >= 5 And cost <= 50 Then
                    If avgnumhour >= 0 And avgnumhour <= 24 Then
                        If power >= 1 And power <= 100 Then
                            If IsWasher Then
                                washerflag = 1
                                If txtCPG.Text <> "" And txtNGWater.Text <> "" Then
                                    numgallon = Integer.Parse(txtNGWater.Text)
                                    gallonwatercost = Double.Parse(txtCPG.Text)
                                    If numgallon > 0 Then
                                        If gallonwatercost >= 1 And gallonwatercost <= 5 Then
                                            totwatercost = numgallon * gallonwatercost
                                            washerflag = 2
                                        Else
                                            MessageBox.Show("Please check the water cost, it should be between 1 and 5")
                                        End If
                                    Else
                                        MessageBox.Show("Please enter number of gallons of water")
                                    End If
                                Else
                                    MessageBox.Show("Please enter number of gallons of water or cost per gallon")
                                End If
                            End If
                            If washerflag = 0 Or washerflag = 2 Then
                                hourcost = avgnumhour * cost / 100.0

                                annualcost = hourcost * 365 + totwatercost * 365 / 100.0
                                overalannualcost += annualcost
                                rowcount = dgvDataList.Rows.Add()
                                dgvDataList.Rows.Item(rowcount).Cells(0).Value = cbxHomeAppliance.Text
                                dgvDataList.Rows.Item(rowcount).Cells(1).Value = txtAvgNumHours.Text
                                dgvDataList.Rows.Item(rowcount).Cells(2).Value = hourcost.ToString("C")
                                dgvDataList.Rows.Item(rowcount).Cells(3).Value = annualcost.ToString("C")

                                txtHourCost.Text = hourcost.ToString("C")
                                txtAnnualCost.Text = annualcost.ToString("C")
                                txtOverallCost.Text = overalannualcost.ToString("C")
                                rowcount += 1

                            End If
                        Else
                            MessageBox.Show("Please check the power in kW, it should be between 1 and 100")
                        End If

                    Else
                        MessageBox.Show("Please check the average number of hour, it should be between 0 and 24")
                    End If
                Else
                    MessageBox.Show("Please check the cost per kW, it should be between 5 and 50")

                End If
            Else
                MessageBox.Show("Please select any one of the home appliance")

            End If
        Else
            MessageBox.Show("Please select the input value (cost or average number of hours or power)")
        End If
        '    Catch ex As Exception
        'MessageBox.Show(ex.Message)

        '   End Try
    End Sub

    Private Sub btnExit_Click(sender As Object, e As EventArgs) Handles btnExit.Click
        End
    End Sub

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        cbxHomeAppliance.SelectedIndex = 0
        IsWasher = False
        rowcount = 0
        overalannualcost = 0
    End Sub


    Private Sub cbxHomeAppliance_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cbxHomeAppliance.SelectedIndexChanged
        Dim appliance As String
        appliance = cbxHomeAppliance.Text.ToLower
        If appliance.Contains("washer") Then
            IsWasher = True
            txtNGWater.Enabled = True
            txtCPG.Enabled = True
        Else
            IsWasher = False
            txtCPG.Text = ""
            txtNGWater.Text = ""
            txtNGWater.Enabled = False
            txtCPG.Enabled = False
        End If
    End Sub

    Private Sub Label1_Click(sender As Object, e As EventArgs) Handles Label1.Click

    End Sub

    Private Sub lnkImport_LinkClicked(sender As Object, e As LinkLabelLinkClickedEventArgs) Handles lnkImport.LinkClicked
        Dim lines As String()
        Dim index As Integer

        ' if no appliance is selected
        If cbxHomeAppliance.SelectedIndex = 0 Then
            MessageBox.Show("Please select any one of the home appliance")
            cbxHomeAppliance.Focus()
            Return
        End If

        ' read all lines from input file
        lines = File.ReadAllLines("PowerRatings.txt")

        ' get index of selected appliance
        index = cbxHomeAppliance.SelectedIndex

        ' get the power as per the appliance index
        txtPower.Text = lines(index - 1)
    End Sub

    Private Sub lnkExport_LinkClicked(sender As Object, e As LinkLabelLinkClickedEventArgs) Handles lnkExport.LinkClicked
        Dim strData As String = ""

        Using writer As StreamWriter = New StreamWriter("data.txt")
            For Each row As DataGridViewRow In dgvDataList.Rows
                If Not row.IsNewRow Then
                    strData += "Appliance: " + row.Cells(0).Value.ToString + vbNewLine
                    strData += "Hours per day: " + row.Cells(1).Value.ToString + vbNewLine
                    strData += "Cost per Hour: " + row.Cells(2).Value.ToString + vbNewLine
                    strData += "Annual Cost: " + row.Cells(3).Value.ToString + vbNewLine
                    writer.WriteLine(strData)
                End If
            Next
        End Using
        MessageBox.Show("Data Exported Successfully to data.txt")
    End Sub
End Class
