
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/*
 Part 2

For this assignment, you are being asked to make sure you are exception
handling by verifying that all of the customer-entered information 
is valid before the order is submitted to ensure order accuracy.

The customer information that the customer must now enter that should be validated includes the following:

Entered user name (must fill in a name)
Entered at least one sub to order
Selected all three attributes for sub (such as bread type, sub type, and sub size)
Entered delivery address that includes street, city, state, and zip code
Entered telephone number xxx-xxx-xxxx
In this assignment, you are adding in error handling to make sure the customer 
is filling in all of the required information.
 */
public class GUI extends JFrame implements ActionListener {

    OrderEntry entry = new OrderEntry();
    JTextField txtName = new JTextField();
    JTextField txtBevQuantity = new JTextField();
    JTextField txtSubQuantity = new JTextField();
    JTextArea outputDisplayArea = new JTextArea(30, 30);
    JButton submit = new JButton("Calculate");
    JComboBox<String> bevCombo;
    JComboBox<String> bevTypeCombo;
    JComboBox<String> subTypeCombo;
    JComboBox<String> subBreadTypeCombo;
    JComboBox<String> subSizeCombo;

    public GUI() {
        super("***Famous Favourite Subs***");
        setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());

        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 2));
        labelPanel.add(new JLabel("Enter your name: "));
        labelPanel.add(txtName);
        
        labelPanel.add(new JLabel("Beverage:"));
        String bev[] = {"Pepsi", "Cola", "Redbull"};
        bevCombo = createJComboBox(bev);
        labelPanel.add(bevCombo);

        labelPanel.add(new JLabel("Type:"));
        String bevType[] = {"Regular", "Diet"};
        bevTypeCombo = createJComboBox(bevType);
        labelPanel.add(bevTypeCombo);

        labelPanel.add(new JLabel("Beverage Quantity:"));
        labelPanel.add(txtBevQuantity);

        labelPanel.add(new JLabel("Sub Type:"));
        String subType[] = {"Veg", "Non Veg"};
        subTypeCombo = createJComboBox(bevType);
        labelPanel.add(subTypeCombo);

        labelPanel.add(new JLabel("Sub Type:"));
        String subBreadType[] = {"Grain Wheat", "Grain Honey Oat", "Italian"};
        subBreadTypeCombo = createJComboBox(subBreadType);
        labelPanel.add(subBreadTypeCombo);

        labelPanel.add(new JLabel("Sub Size:"));
        String subSize[] = {"6", "12"};
        subSizeCombo = createJComboBox(subSize);
        labelPanel.add(subSizeCombo);

         labelPanel.add(new JLabel("Sub Quantity:"));
        labelPanel.add(txtSubQuantity);
        
        p1.add(labelPanel, BorderLayout.CENTER);
        p1.add(submit, BorderLayout.SOUTH);

        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add(new JLabel("Output: "), BorderLayout.NORTH);
        p2.add(new JScrollPane(outputDisplayArea), BorderLayout.CENTER);
        outputDisplayArea.setEditable(false);

        add(p2, BorderLayout.CENTER);
        add(p1, BorderLayout.NORTH);

        submit.addActionListener(this);

        //packing and displaying the GUI
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(700, 500);
        setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
         entry.processOrders(this);
    }

    /**
     * method to create combo box
     *
     * @param description
     * @return
     */
    private JComboBox createJComboBox(String[] description) {
        JComboBox c = new JComboBox();
        for (int i = 0; i < description.length; i++) {
            c.addItem(description[i]);
        }

        return c;
    }
    
    public static void main(String[] args) {
        new GUI();
    }
}
