
import javax.swing.JOptionPane;

/*
 upgrade the application by including a subclass that uses vectors 
 and/or wrapper classes along with string conversion for input captured.
 */
 

public class OrderEntry extends Order {
    /**
     * Uses Lists(Vector)
     */
    public void processOrders(GUI gui) {

        processOrder(gui);

    }

    private void processOrder(GUI gui) {
        String msg = "";
        String brand = gui.txtName.getText();
        String bname = (String) gui.bevCombo.getSelectedItem();
        double price = 0;
        if ("Pepsi".equalsIgnoreCase(brand)) {
            price = 2.5;
        } else if ("Cola".equalsIgnoreCase(brand)) {
            price = 2.25;
        } else if ("Redbull".equalsIgnoreCase(brand)) {
            price = 5.25;
        } else {
            price = 1.25;
        }

        int quantity =0;
        try {
            quantity = Integer.parseInt(gui.txtBevQuantity.getText());
            if(quantity<=0){
                displayStringUsingPane("Please enter positive(>0) quantity of Beverage");
            return;
            }
        }catch(Exception e ){
            displayStringUsingPane("Please enter numeric quantity of Beverage");
            return;
        }
        Beverage beverage = new Beverage(brand, bname, price, quantity);
        super.setBeverage(beverage);

        String type = (String) gui.subTypeCombo.getSelectedItem();
        String bread = (String) gui.subBreadTypeCombo.getSelectedItem();
        String sname = type + " " + bread;
        int size = Integer.parseInt((String) gui.subSizeCombo.getSelectedItem());
        
        try {
            quantity = Integer.parseInt(gui.txtSubQuantity.getText());
            if(quantity<=0){
                displayStringUsingPane("Please enter positive(>0) quantity of Sub");
            return;
            }
        }catch(Exception e ){
            displayStringUsingPane("Please enter numeric quantity of Sub");
            return;
        }
        
        if (size == 6) {
            price = 7.75;
        } else {
            //for foot long
            price = 12.75;
        }
        Sub sub = new Sub(bread, type, size, sname, price, quantity);
        super.setSub(sub);
        msg += super.toString() + "\n\n";
        gui.outputDisplayArea.append(msg);

    }

     /**
     * Method to display string using pane
     *
     * @param msg
     * @
     */
    public   void displayStringUsingPane(String msg) {
        JOptionPane.showMessageDialog(null, msg);
    }
}
