﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CardLibrary
{
    public class CardSet
    {
        public SuperCard[] cardArray;
        Random rand = new Random();

        public CardSet()
        {
            cardArray = new SuperCard[52];
            int cardCount = 0;

            for (Suit suit = Suit.Club; suit <= Suit.Spade; suit++)
            {
                for (Rank rank = Rank.Deuce; rank <= Rank.Ace; rank++)
                {
                    switch (suit)
                    {
                        case Suit.Club:
                            cardArray[cardCount++] = new CardClub(rank);
                            break;
                        case Suit.Diamond:
                            cardArray[cardCount++] = new CardDiamond(rank);
                            break;
                        case Suit.Heart:
                            cardArray[cardCount++] = new CardHeart(rank);
                            break;
                        case Suit.Spade:
                            cardArray[cardCount++] = new CardSpade(rank);
                            break;
                    }

                }
            }
        }

        // It picks number cards (the number you passed in) at random from the your CardArray[] and returns them as an array.
        public SuperCard[] GetCards(int number)
        {
            SuperCard[] cards = new SuperCard[number];

            int cardType = rand.Next(1, 5);

            for (int i = 0; i < number; i++)
            {
                if (cardType == 1)
                    cards[i] = new CardClub((Rank)rand.Next(2, 15));
                else if(cardType == 2)
                    cards[i] = new CardDiamond((Rank)rand.Next(2, 15));
                else if (cardType == 3)
                    cards[i] = new CardHeart((Rank)rand.Next(2, 15));
                else if (cardType == 4)
                    cards[i] = new CardSpade((Rank)rand.Next(2, 15));
            }

            return cards;
        }
    }
}
