﻿using CardLibrary;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PokerProject
{
    class Program
    {
        static void Main(string[] args)
        {
            // a. Create an instance of CardSet class, and call it myDeck.
            CardSet myDeck = new CardSet();

            int howManyCards = 5;
            int balance = 10;
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.BackgroundColor = ConsoleColor.DarkBlue;

            Console.WriteLine("Welcome to the Poker Game.");
            Console.WriteLine("You have $10 and each bet will be $1.");
            Console.WriteLine("Press any key when you are ready to start.");
            Console.ReadLine();

            while (balance != 0)
            {
                SuperCard[] computerHand = myDeck.GetCards(howManyCards);
                SuperCard[] playersHand = myDeck.GetCards(howManyCards);

                DisplayHands(computerHand, playersHand);

                bool won = CompareHands(computerHand, playersHand);

                if (won)
                {
                    Console.WriteLine("You won.");
                }
                else
                {
                    Console.WriteLine("You lost.");
                }

                Console.WriteLine("You have $" + balance + "\tType Enter for another Hand");
                Console.ReadLine();

                balance -= 1;
            }

            Console.WriteLine("You lost.");

            // end of program
            Console.ReadLine();

        }

        private static bool CompareHands(SuperCard[] computerHand, SuperCard[] playersHand)
        {
            int computerTotal = 0;
            int playerTotal = 0;

            for(int i=0; i<computerHand.Length; i++)
            {
                computerTotal += (int)(computerHand[i].CardRank);
            }
            for (int i = 0; i < playersHand.Length; i++)
            {
                playerTotal += (int)(playersHand[i].CardRank);
            }

            if (playerTotal > computerTotal)
                return true;
            else
                return false;

        }

        private static void DisplayHands(SuperCard[] computerHand, SuperCard[] playersHand)
        {
            Console.WriteLine("DEALER HAND");
            for (int i = 0; i < computerHand.Length; i++)
            {
                computerHand[i].Display();
            }

            Console.ResetColor();

            Console.WriteLine("\nYOUR HAND");
            for (int i = 0; i < playersHand.Length; i++)
            {
                playersHand[i].Display();
            }

            Console.ResetColor();
        }
    }
}
