﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ClassLibrary1
{
    public class Car
    {
        // fields
        private decimal _myCurrentSpeedMPH; // the cars current speed
        private decimal _myMaxSpeedMPH;  // the upper limit, the car cannot exceed this value
        private bool _myEngineRunning;  // true means the engine has been started and is running, false says engine is off

        public Car(decimal maxSpeed) // constuctor, user chooses to set maxSpeed as they create the object
        {
            _myMaxSpeedMPH = maxSpeed;
            _myCurrentSpeedMPH = 0;
            _myEngineRunning = false;
        }

      
        public bool EngineRunning   // Property to allow reading the current value
        {
            get
            {
                return _myEngineRunning;
            }
        }

        public decimal CurrentSpeedMPH    // Property to allow reading the current value
        {
            get
            {
                return _myCurrentSpeedMPH;
            }
        }
     

    
        public void StartEngine()  // method used to start car's engine
        {
            _myEngineRunning = true;
        }

        public void StopEngine()    // method used to stop car's engine
        {
            _myEngineRunning = false;
        }


        public void Accelerate()  // method used to increase the cars speed
        {
            _myCurrentSpeedMPH = _myCurrentSpeedMPH + 10;  // this method always tries to increase by 10 mph
            if (_myCurrentSpeedMPH > _myMaxSpeedMPH)  // but it can never exceed the max speed as set in the constructor
            {
                _myCurrentSpeedMPH = _myMaxSpeedMPH;  // if speed is higher than max, set it to max
            }
        }

        public void Decelerate()  // this method always tries to decrease the speed by 5 mph
        {
            _myCurrentSpeedMPH = _myCurrentSpeedMPH - 5;  // but never lets it go below 0 and become negative.
            if (_myCurrentSpeedMPH < 0)
            {
                _myCurrentSpeedMPH = 0;
            }
        }

       
    }
}
