#include "game.h"
#include "consoleutil.h"
#include <stdio.h>

// moves for players. each list in order defined by Entity::Move_XXXX variables
char * moveCommands[] = {"wasd", "ijkl"};
const int NUMBER_OF_PLAYERS = sizeof(moveCommands) / sizeof(moveCommands[0]);

Game::Game()
{
	state = RUNNING;
	size.init(20,15);
	// allocate each entity
	list[PLAYER1] = new Entity(4,3,1);
	list[GOAL1] = new Entity(10,7,4);
	list [GOAL2]= new Entity (1,1,3);
	Vector2 g1 = list[GOAL1]->getPosition();
	Vector2 p1 = list[PLAYER1]->getPosition();
	list[PLAYER2] = new Entity(
		(g1.x + p1.x)/2, 
		(g1.y + p1.y)/2, 5);
	// TODO overload operators below to replace logic above
	//Vector2 p2 = (g1 + p1) / 2;
	//list[PLAYER2] = new Entity(p2.x, p2.y, 5);
}

void Game::draw()
{
	// draw the game world
	moveCursor(0,0);
	for(int row = 0; row < size.y; row++) {
		for(int col = 0; col < size.x; col++) {
			putchar('.');
		}
		putchar('\n');
	}
	// draw players in the game
	for(int i = 0; i < LIST_SIZE; ++i) {
		list[i]->draw();
	}
	// inform player how to play
	for(int i = 0; i < NUMBER_OF_PLAYERS; i++) {
		moveCursor(0, size.y+i);
		printf("use \"%s\" to move %c\n", 
			moveCommands[i], list[i]->getIcon());
	}
}

void Game::update()
{
	// if the user pressed the escape key
	if(userInput == 27) {
		state = USER_QUIT;
		return;	// quit
	}
	// move the players, based on what key was pressed
	int whatMove = Entity::MOVE_NONE, whosTurnItIs;
	for(int player = 0; player < NUMBER_OF_PLAYERS; ++player) {
		for(int i = 0; moveCommands[player][i] != '\0'; ++i) {
			if(moveCommands[player][i] == userInput) {
				whosTurnItIs = player;
				whatMove = i;
				break;
			}
		}
		if(whatMove != Entity::MOVE_NONE) {
			break;
		}
	}
	if(whatMove != Entity::MOVE_NONE) {
		list[whosTurnItIs]->move(whatMove);
	}
	// game logic
	for(int i = 0; i < LIST_SIZE; ++i) {
		list[i]->update();
	}
	Entity * player1 = list[PLAYER1];
	Entity * player2 = list[PLAYER2];
	Entity * goal = list[GOAL1];
	if(goal->getPosition().is(player1->getPosition())) {
		state = WIN;
	}
	if(!player1->getPosition().isWithin(0, 0, size.x, size.y)) {
		state = LOST;
	}
	if(player2->getPosition().is(player1->getPosition())) {
		state = DEFEAT;
	}
	// show the end-of-game state message when the game ends
	if(state != Game::RUNNING) {
		moveCursor(0, size.y+NUMBER_OF_PLAYERS+1);
		char * message;
		switch(state)
		{
		case WIN:	message = "Goal ACHIEVED!";		break;
		case LOST:	message = "Player lost...";		break;
		case DEFEAT:message = "Player was CLUBBED";	break;
		default:	message = "unknown state occured";	break;
		}
		printf("%s\n\n", message);
	}
}

Game::~Game()
{
	// de-allocate each entity
	for(int i = 0; i < LIST_SIZE; ++i)
		delete list[i];
}
