#pragma once
#include "entity.h"
#include "vector2.h"

class Game
{
private:
	static const int LIST_SIZE = 4;
	Entity* list[LIST_SIZE];
	/** labels for which Entity in 'list' is what*/
	static const int 
		PLAYER1 = 0, 
		PLAYER2 = 1, 
		GOAL1 = 2,
		GOAL2 = 3;

	/** width/height of the map */
	Vector2 size;
	int userInput;
	int state;
public:
	void setInput(int input){	userInput = input; }
	int getState()			{	return state; }
	/** game state constants */
	static const int 
		RUNNING = 1, 
		WIN = 2, 
		LOST = 3, 
		DEFEAT = 4, 
		USER_QUIT = -1;
	Game();
	void draw();
	void update();
	~Game();
};
