// lab4: simplegame_Inheritance
// <insert your name here>
// read main.cpp, and follow the instructions at the bottom of main.cpp

#include <stdio.h>		// printf(char*, ...), putchar(int)
#include <conio.h>		// _getch()

#include "game.h"

void main()
{
	Game game;
	do
	{
		game.draw();
		game.setInput(_getch());
		game.update();
	}
	while(game.getState() == Game::RUNNING);
	printf("press ESCAPE to quit\n");
	while(_getch() != 27);
}

// INSTRUCTIONS
// ------------
// Compile this code. You should see a rectangular play field of periods, with
// 3 Entity objects visible on it. The happy-face Entity moves with the "wasd"
// keys, and the club Entity moves with the "ijkl" keys. If the happy-face
// reaches the diamond Entity, the player wins. If the happy-face reaches the
// club, the player loses.
//
// Read through this code! Try to understand it before starting the assignment.
// Comment confusing lines with what you think code is doing, and experiment
// with existing code to test your understanding.
// Once you feel comfortable with this code, accomplish each of the following,
// and make sure your code compiles and runs after each step is completed.
//
// 1) Getting comfortable with the game code
//   a) Implement initialization lists in Vector2, Entity, and Game (setting 
//      object values after a ':', between the constructor signature and body).
//      Have initialization lists set initial values for each member variable.
//   b) Add another Entity to the game that isn't the same location as an
//      existing Entity. Use a heart icon (ASCII code 3). It should display in
//      the game.
//   c) Add logic that makes the club (PLAYER2) win the game if that player
//      reaches the heart Entity. You may want to make new constants, like
//      GOAL2, and WIN2, to follow the existing code convention.
//   d) Make a new private function called "void Game::handleUserInput()", move
//      the user input handling logic from Game::update() into this new
//      function, and call Game::handleUserInput from Game::update.
//   e) Add whitespace to the handleUserInput logic, and comment each line with
//      what you understand it is doing. If you don't understand what the code
//      is doing, experiment with it until you do! Do things like printing
//      variables you are unsure about, and guess what output will look like.
//   f) Implement the prototyped overloaded operators for Vector2. Once they
//      are finished you should be able to use the alternate code for setting
//      up PLAYER2 in Game::Game() in "game.cpp".
// 2) A "BlinkEntity" class
//   a) Create 2 new files in your project: "blinkentity.h", and
//      "blinkentity.cpp"
//   b) Make a BlinkEntity class that extends Entity. Declare the class in
//      "blinkentity.h" and define it's methods in "blinkentity.cpp". Your
//      "blinkentity.h" file should look something like:
//          #pragma once
//
//          #include "entity.h"
//
//          class BlinkEntity : public Entity {
//          };
//   c) Instead of using an Entity for the Entity marked GOAL1 in the Game
//      constructor, use a BlinkEntity. You will need to create a public 
//      BlinkEntity constructor.
//   d) Give BlinkEntity another member variable called "alternateIcon". When
//      BlinkEntity calls it's update function, swap the values of "icon" and
//      "alternateIcon". You won't notice a change during runtime until you add
//      the virtual modifier to Entity::update().
// 3) A "WanderingEntity" class
//   a) Create 2 new files in your project: "wanderingentity.h", and
//      "wanderingentity.cpp"
//   b) Make a WanderingEntity class that extends Entity. Declare the class in
//      "wanderingentity.h" and define it's methods in "wanderingentity.cpp".
//      Your "wanderingentity.h" file should look something like:
//          #pragma once
//
//          #include "entity.h"
//
//          class WanderingEntity : public Entity {
//          };
//   c) Instead of using an Entity for the Entity marked PLAYER2 in the Game
//      constructor, use a WanderingEntity. You will need to create a public
//      WanderingEntity constructor.
//   d) Create a new update method for WanderingEntity. Declare it in
//      "wanderingentity.h", and define it in "wanderingentity.cpp". In the
//      WanderingEntity::update() method, set the "howToMoveNext" variable
//      to a random number from 0 to 3. You can use "rand() % 4" to do this in
//      "wanderingentity.cpp" if you #include <cstdlib> or <stdlib.h>. After
//      setting the "howToMoveNext" variable in update, call the parent class's
//      updated with "Entity::update()".
//   e) Add at least 2 more WanderingEntity objects in the Game. Add game logic
//      will cause the player to lose if the player shares a location with any
//      WanderingEntity object.

// Achievements: (if you finished, and would like a challenge, try these)
//
// [Tis But A Scratch!] Make a player a separate class inheriting from Entity.
//     Give the Player class 3 "hitpoints". Each hitpoint will allow the player
//     to share a location with a WanderingEntity up to 3 times before losing.
// [Out Of Bounds!] Implement logic to prevent the player and the
//     WanderingEntity objects from leaving the game boundaries.
// [Your Princes Is In Another Castle] After the player reaches the object
//     marked GOAL1, make GOAL1 randomly appear in another location. Increment
//     a score each time the player reaches the goal, and display it while the
//     game is being played.
// [The Colors...] Implement colors using SetConsoleTextAttribute from 
//     "Windows.h". For example, make the player green, the WanderingEntity
//     objects red, and the goal yellow.
// [How Many Did You See?] Allow the user to type how many WanderingEntity
//     objects should be in the game. Use a dynamic array of WanderingEntity
//     objects to support any number!
// [Level 1-1] Create a 2-dimensional array of characters to act as a map/game-
//     environment. Make some characters impassable by the player object,
//     WanderingEntity objects, and/or both!
// [This Way --No That Way!] Implement logic to prevent WanderingEntity objects
//     from occupying the same space. When a WanderingEntity moves to the same 
//     location as another WanderingEntity, have it move back to its previous
//     location.
// [He's Smarter Than He Looks] Implement a Hunter class, inheriting from
//     WanderingEntity, that moves toward the player. Once the algorithm to 
//     move toward the player is done, add logic that will make the follow-
//     logic activate only every-other move.
// [Now It's My Turn] Implement logic that de-activates a WanderingEntity if
//     the player moves into it first. A de-activated WanderingEntity should
//     not be drawn, and should not cause collision of any kind.
// [Wait For Me!] Use _kbhit() from <conio.h> to continue the game loop even if
//     the user has not pressed a key. You will need to implement some kind of
//     throttle code. Consider implementing the following throttle function in
//     the "consoleutil", library which requires _kbhit() (from <conio.h>),
//     clock() (from <ctime>), and Sleep() (from <windows.h>):
//         void throttle(int msWait) {
//             long now = clock();
//             long soon = now + msWait;
//             while(!_kbhit() && clock() < soon){ Sleep(1); }
//         }
// [Look Ma, No Leaks!] Download and use VLD (Visual Leak Detector) to find
//     your memory leaks. If VLD shows you a memory leak, fix it by using
//     "delete" on allocated memory. VLD is a free tool for Visual Studio,
//     search for it using your favorite search engine!

// When finished:
// 1) Make sure your name is at the top of this source file
// 2) Submit this project online
//   a) Right-click on the .cpp file's name within visual studio, and select
//      "Open Containing Folder"
//   b) Close Visual Studio (you may re-open this .cpp file by right-clicking
//      on it in the file system, and slecting edit)
//   c) Make sure the following files are DELETED from the project's file
//      structure:
//      * Any file with the extension: ".ncb", ".sdf"
//      * Any folder named: "Debug" or "ipch"
//      * If Visual Studio is open, you will not be able to delete some files
//      * If you do not see file extensions, press Alt in the file explorer,
//        select "Tools"->"Folder options..."->"View", and uncheck
//        "Hide extensions for known file types".
//   d) zip the file structure (the project), which is now missing the
//      temporary files
//      * Select all of the files in the project folder
//      * If the resulting zip file is more than 1mb, you have included
//        temporary files mentioned above. Delete temporary files (that don't
//        have a .cpp or .h extension) and try again.
//   e) upload the project to the appropriate week's iLab at the GSP125
//      website, linked from http://www.devryu.net
