#include "vector2.h"

/** @return true if the given x, y coordinate matches this Vector2's data */
bool Vector2::is(short x, short y)
{
	return this->x == x && this->y == y;
}

/** @return true if the given x, y coordinate matches this Vector2's data */
bool Vector2::is(Vector2 xy)
{
	return xy.x == x && xy.y == y;
}

/** @return true if the Vector2 is within the given rectangular boundary */
bool Vector2::isWithin(short minx, short miny, short maxx, short maxy)
{
	return x >= minx && y >= miny && x < maxx && y < maxy;
}

/** re-initialize */
void Vector2::init(short a_x, short a_y)
{
	x = a_x;
	y = a_y;
}

Vector2& Vector2::operator+=(Vector2& v)
{
	x += v.x;
	y += v.y;
	return *this;
}
Vector2 Vector2::operator+(Vector2& v)
{
	return Vector2(x+v.x, y+v.y);
}
Vector2& Vector2::operator*=(short value)
{
	x *= value;
	y *= value;
	return *this;
}
Vector2 Vector2::operator*(short value)
{
	return Vector2(x*value, y*value);
}

#include "stdlib.h"
/** @return a random Vector2 within the specified boundary */
Vector2 Vector2::random(Vector2 min, Vector2 max)
{
	return Vector2(
		(rand() % (max.x-min.x)) + min.x,
		(rand() % (max.y-min.y)) + min.y);
}
