#pragma once

/**
 * Object Oriented implementation of a 2 dimensional (math) vector, using short precision
 */
struct Vector2
{
	/** the x, y coordinates */
	short x, y;
	/** initializes the Vector2 */
	Vector2(short x, short y)
	{
		this->x = x;
		this->y = y;
	}
	/** default constructor - sets x,y to 0,0 */
	Vector2()
	{
		x = 0;
		y = 0;
	}
	/** @return true if the given x, y coordinate mathes this Vector2's data */
	bool is(short x, short y);

	/** @return true if the given x, y coordinate mathes this Vector2's data */
	bool is(Vector2 xy);

	/** @return true if the Vector2 is within the given rectangular boundary */
	bool isWithin(short minx, short miny, short maxx, short maxy);

	/** re-initialize */
	void init(short x, short y);

	/** @return a random Vector2 within the specified boundary */
	static Vector2 random(Vector2 min, Vector2 max);

	Vector2& operator+=(Vector2& v);
	Vector2 operator+(Vector2& v);
	Vector2& operator*=(short value);
	Vector2 operator*(short value);
	// TODO implement these...
	Vector2& operator-=(Vector2& v);
	Vector2 operator-(Vector2& v);
	Vector2& operator/=(short value);
	Vector2 operator/(short value);
};
