﻿using Microsoft.VisualBasic;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Missions
{
    public partial class Form1 : Form
    {
        // file names
        const String MissionaryInWaiting = "MissionaryInWaiting.txt";
        const String MissionaryInField = "MissionaryInField.txt";

        public Form1()
        {
            InitializeComponent();
            refreshListBoxes();
        }

        /// <summary>
        /// refreshes both text boxes
        /// </summary>
        private void refreshListBoxes()
        {
            refreshMissionaryInWaiting();
            refreshMissionaryInField();
        }

        private void btnAddMissionary_Click(object sender, EventArgs e)
        {
            // read missionary from user inout
            string missionary = Interaction.InputBox("Enter Missionary Name:", "Add Missionary", "").Trim();

            if(missionary.Trim()== string.Empty)
            {
                MessageBox.Show("Name cannot be blank");
                return;
            }

            // check for duplicate name
            if(lbAvailable.FindString(missionary) > 0 || lbField.FindString(missionary) > 0 )
            {
                MessageBox.Show("A missionary with the same name already exists! Please enter different name.");
                return;
            }

            StreamWriter writer;

            // if file does not exist, create a new file
            if (!File.Exists(MissionaryInWaiting))
                writer = File.CreateText(MissionaryInWaiting);
            else
                writer = File.AppendText(MissionaryInWaiting);

            // append the missionary to the file
            writer.WriteLine(missionary);

            // close file after writing
            writer.Close();

            // refresh missionary in waiting list
            refreshMissionaryInWaiting();
        }

        /// <summary>
        /// refreshes the Missionary In Waiting Listbox
        /// </summary>
        private void refreshMissionaryInWaiting()
        {
            // check if file exists
            if (File.Exists(MissionaryInWaiting))
            {
                // clear the list box
                lbAvailable.Items.Clear();

                // read all lines
                var allLines = File.ReadAllLines(MissionaryInWaiting).ToList();

                // set numbers in field
                txtNumberAvailable.Text = allLines.Count.ToString();

                // fill list box with items in file
                allLines.ForEach(x => lbAvailable.Items.Add(x));
            }
            else
                txtNumberAvailable.Text = "0";
        }

        /// <summary>
        /// refreshes the Missionary In Field Listbox
        /// </summary>
        private void refreshMissionaryInField()
        {
            // check if file exists
            if (File.Exists(MissionaryInField))
            {
                // clear the list box
                lbField.Items.Clear();

                // read all lines
                var allLines = File.ReadAllLines(MissionaryInField).ToList();

                // set numbers available
                txtNumberInField.Text = allLines.Count.ToString();

                // fill list box with items in file
                allLines.ForEach(x => lbField.Items.Add(x));
            }
            else
                txtNumberInField.Text = "0";
        }

        private void btnQuit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnGoToField_Click(object sender, EventArgs e)
        {
            ListBox.SelectedObjectCollection availableMissionaries = getAvailableMissionaries();
            if (availableMissionaries != null && availableMissionaries.Count > 0)
            {
                // add to field
                foreach (var item in availableMissionaries)
                {
                    lbField.Items.Add(item);
                }

                // remove selected missionaries from available missionaries
                if (lbAvailable.SelectedIndex != -1)
                {
                    for (int i = availableMissionaries.Count - 1; i >= 0; i--)
                        lbAvailable.Items.Remove(availableMissionaries[i]);
                }

                // update files
                updateFiles();

                // update both listboxes
                refreshListBoxes();
            }
        }

        // update files
        private void updateFiles()
        {
            // update available missionaries
            StreamWriter writer = File.CreateText(MissionaryInWaiting);

            // write to file
            foreach (var item in lbAvailable.Items)
            {
                writer.WriteLine(item.ToString());
            }

            // close the file
            writer.Close();

            // update missionaries in field
            writer = File.CreateText(MissionaryInField);

            // write to file
            foreach (var item in lbField.Items)
            {
                writer.WriteLine(item.ToString());
            }

            // close the file
            writer.Close();
        }

        /// <summary>
        /// returns available missionaries
        /// </summary>
        /// <returns></returns>
        private ListBox.SelectedObjectCollection getAvailableMissionaries()
        {
            // if there is no selected missionary
            if (lbAvailable.SelectedItems.Count == 0)
            {
                MessageBox.Show("No Available Missionary is selected");
                return null;
            }

            ListBox.SelectedObjectCollection selected = lbAvailable.SelectedItems;

            return selected;
        }

        /// <summary>
        /// returns field missionaries
        /// </summary>
        /// <returns></returns>
        private ListBox.SelectedObjectCollection getFieldMissionaries()
        {
            // if there is no selected missionary
            if (lbField.SelectedItems.Count == 0)
            {
                MessageBox.Show("No Field Missionary is selected");
                return null;
            }

            ListBox.SelectedObjectCollection selected = lbField.SelectedItems;

            return selected;
        }

        private void btnLeavingField_Click(object sender, EventArgs e)
        {
            ListBox.SelectedObjectCollection fieldMissionaries = getFieldMissionaries();
            if (fieldMissionaries != null && fieldMissionaries.Count > 0)
            {
                // add to available
                foreach (var item in fieldMissionaries)
                {
                    lbAvailable.Items.Add(item);
                }

                // remove selected missionaries from field missionaries
                if (lbField.SelectedIndex != -1)
                {
                    for (int i = fieldMissionaries.Count - 1; i >= 0; i--)
                        lbField.Items.Remove(fieldMissionaries[i]);
                }

                // update files
                updateFiles();

                // update both listboxes
                refreshListBoxes();
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            // if no missionary is selected
            if (lbAvailable.SelectedItems.Count > 0 || lbField.SelectedItems.Count > 0)
            {
                ListBox.SelectedObjectCollection selectedAvailable = lbAvailable.SelectedItems;
                ListBox.SelectedObjectCollection selectedField = lbField.SelectedItems;

                // remove selected missionaries from available missionaries
                for (int i = selectedAvailable.Count - 1; i >= 0; i--)
                    lbAvailable.Items.Remove(selectedAvailable[i]);

                // remove selected missionaries from field missionaries
                for (int i = selectedField.Count - 1; i >= 0; i--)
                    lbField.Items.Remove(selectedField[i]);

                // update files
                updateFiles();

                // update both listboxes
                refreshListBoxes();
            }
            else
            {
                MessageBox.Show("No Missionary is selected to delete.");
            }
        }

        private void btnSort_Click(object sender, EventArgs e)
        {
            // check if items are available to sort
            if(lbAvailable.Items.Count == 0 && lbField.Items.Count == 0)
            {
                MessageBox.Show("No Item to sort");
                return;
            }
            
            /* Sort Available Missionaries  */
            // make array list of items
            ArrayList listAvailable = new ArrayList();
            foreach (var item in lbAvailable.Items)
                listAvailable.Add(item);

            // sort the list
            listAvailable.Sort();

            // bind the listbox again
            lbAvailable.Items.Clear();
            foreach (var item in listAvailable)
            {
                lbAvailable.Items.Add(item);
            }

            /* Sort Fiels Missionaries  */
            // make array list of items
            ArrayList listField = new ArrayList();
            foreach (var item in lbField.Items)
                listField.Add(item);

            // sort the list
            listField.Sort();

            // bind the listbox again
            lbField.Items.Clear();
            foreach (var item in listField)
            {
                lbField.Items.Add(item);
            }

            // update files
            updateFiles();

            // update both listboxes
            refreshListBoxes();
        }

        private void label4_Click(object sender, EventArgs e)
        {

        }

        private void lbAvailable_SelectedIndexChanged(object sender, EventArgs e)
        {

        }
    }
}
