﻿using PayrollSystem;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

public delegate int DelCompare(IPayable  e1, IPayable e2);
public abstract class Employee : IPayable
{
    // read-only property that gets employee's first name
    public string FirstName { get; private set; }

    // read-only property that gets employee's last name
    public string LastName { get; private set; }

    // read-only property that gets employee's social security number
    public string SocialSecurityNumber { get; private set; }

    // three-parameter constructor
    public Employee(string first, string last, string ssn)
    {
        FirstName = first;
        LastName = last;
        SocialSecurityNumber = ssn;
    } // end three-parameter Employee constructor

    ///<summary> return string representation of Employee object, using properties </summary>
    public override string ToString()
    {
        return string.Format("{0} {1}\nsocial security number: {2}",
           FirstName, LastName, SocialSecurityNumber);
    }

    public abstract decimal GetPaymentAmount();

    ///<summary>compare function is used to compare employees from 
    ///employee basing on there last name</summary>
    public int CompareTo(Employee e2)
    {
        int result = String.Compare(e2.LastName, LastName);
        return result;
    }
    ///<summary>Its a delegate handler to handle compare socialsecuritynmber
    ///compare function is used to compare employees from employee basing on there social security number</summary>
    public static int CompareSocialSecurityNumber(IPayable emp1, IPayable emp2)
    {
        Employee e1 = (Employee)emp1;
        Employee e2 = (Employee)emp2;
        int result = string.Compare(e1.SocialSecurityNumber, e2.SocialSecurityNumber);
        return result;
    }
    ///<summary>sort function for sorting employees 
    ///based on ssn using delegate and selection sort
    ///</summary>                            
    public static void sort(DelCompare delCompare, IPayable[] employeeList)
    {
        for (int i = 0; i < employeeList.Length; i++)
        {
            Employee small = (Employee)employeeList[i];
            int pos = i;
            for (int j = i; j < employeeList.Length; j++)
            {
                //compare function to swap basing on the value of ssn of the employee
                if (delCompare(employeeList[i], employeeList[j]) < 0)
                {
                    small = (Employee )employeeList[j];
                    pos = j;
                }
                Employee obj;
                obj =(Employee ) employeeList[i];
                employeeList[i] = employeeList[pos];
                employeeList[pos] = obj;

            }
        }
    }




    public int Compare(IPayable a, IPayable b)
        {
            Employee e1 = (Employee)a;
            Employee e2 = (Employee)b;

            if (e1.GetPaymentAmount() > e2.GetPaymentAmount())
            {
                return 1;
            }

            if (e1.GetPaymentAmount() < e2.GetPaymentAmount())
            {
                return -1;
            }

            return 0;
        }
    


    public int CompareTo(IPayable other)

    {
        Employee a =(Employee )other;
        int result = String.Compare(a.LastName, LastName);
        return result;
    }

    

  

} // end abstract class Employee


