﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PayrollSystem
{
    public class PayableInterfaceTest
    {
        public static void Main(string[] args)
        {

            IPayable[] payableObjects = new IPayable[8];
            payableObjects[0] = new SalariedEmployee("John", "Smith", "111-11-1111", 700M);
            payableObjects[1] = new SalariedEmployee("Antonio", "Smith", "555-55-5555", 800M);
            payableObjects[2] = new SalariedEmployee("Victor", "Smith", "444-44-4444", 600M);
            payableObjects[3] = new HourlyEmployee("Karen", "Price", "222-22-2222", 16.75M, 40M);
            payableObjects[4] = new HourlyEmployee("Ruben", "Zamora", "666-66-6666", 20.00M, 40M);
            payableObjects[5] = new CommissionEmployee("Sue", "Jones", "333-33-3333", 10000M, .06M);
            payableObjects[6] = new BasePlusCommissionEmployee("Bob", "Lewis", "777-77-7777", 5000M, .04M, 300M);
            payableObjects[7] = new BasePlusCommissionEmployee("Lee", "Duarte", "888-88-888", 5000M, .04M, 300M);

            Console.WriteLine("Employees processed polymorphically:\n");

            ///<summary>generically process each element in array employees</summary> 
            foreach (Employee currentEmployee in payableObjects)
            {
                Console.WriteLine(currentEmployee); // invokes ToString

                // determine whether element is a BasePlusCommissionEmployee
                if (currentEmployee is BasePlusCommissionEmployee)
                {
                    // downcast Employee reference to 
                    // BasePlusCommissionEmployee reference
                    BasePlusCommissionEmployee employee =
                       (BasePlusCommissionEmployee)currentEmployee;

                    employee.BaseSalary *= 1.10M;
                    Console.WriteLine(
                       "new base salary with 10% increase is: {0:C}",
                       employee.BaseSalary);
                } // end if

                Console.WriteLine(
                   "earned {0:C}\n", currentEmployee.GetPaymentAmount());
            } // end foreach

            ///<summary>get type name of each object in employees array</summary> 
            for (int j = 0; j < payableObjects.Length; j++)
                Console.WriteLine("Employee {0} is a {1}", j,
                   payableObjects[j].GetType());



            //emp = (Employee[])payableObjects;
            //emp = payableObjects;
            ///<summary>menu that allows a user to select one of the following options 
            ///to display a string representation of each IPayable objects.</summary>
            while (true)
            {
                Console.WriteLine("Select Option: ");
                Console.WriteLine("1. Sort last name in descending order using IComparable: ");
                Console.WriteLine("2. Sort pay amount in ascending order using IComparer: ");
                Console.WriteLine("3. Sort by social security number in descending order using a selection sort and delegate ");
                Console.WriteLine("4. Exit");
                Console.Write("Enter the option: ");
                int option = Convert.ToInt32(Console.ReadLine());

                if (option == 1)
                {
                    Array.Sort<IPayable>(payableObjects);
                    for (int j = 0; j < payableObjects.Length; j++)
                    {
                        Console.WriteLine("Employee {0} is a {1}", j,
                           payableObjects[j].ToString());
                        Console.WriteLine();
                    }
                }

                if (option == 2)
                {
                    Array.Sort<IPayable>(payableObjects);
                    for (int j = 0; j < payableObjects.Length; j++)
                    {
                        Console.WriteLine("Employee {0} is a {1}", j,
                           payableObjects[j].ToString());
                        Console.WriteLine();
                    }
                }

                if (option == 3)
                {
                    Employee.sort(Employee.CompareSocialSecurityNumber, payableObjects);
                    for (int j = 0; j < payableObjects.Length; j++)
                    {
                        Console.WriteLine("Employee {0} is a {1}", j,
                           payableObjects[j].ToString());
                        Console.WriteLine();
                    }
                }
                if (option == 4)
                {
                    return;
                }
            }

        } // end Main

    } // end class PayrollSystemTest
}
