﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PayrollSystem
{
    public class SalariedEmployee : Employee
    {
        private decimal weeklySalary;

        ///<summary> four-parameter constructor </summary> 
        public SalariedEmployee(string first, string last, string ssn,
           decimal salary) : base(first, last, ssn)
        {
            WeeklySalary = salary; // validate salary via property
        } // end four-parameter SalariedEmployee constructor

        ///<summary>property that gets and sets salaried employee's salary</summary>
        public decimal WeeklySalary
        {
            get
            {
                return weeklySalary;
            } // end get
            set
            {
                if (value >= 0) // validation
                    weeklySalary = value;
                else
                    throw new ArgumentOutOfRangeException("WeeklySalary",
                       value, "WeeklySalary must be >= 0");
            } // end set
        } // end property WeeklySalary

        ///<summary> calculate earnings; override abstract method Earnings in Employee </summary> 
        public override decimal GetPaymentAmount()
        {
            return WeeklySalary;
        } // end method Earnings          

        // return string representation of SalariedEmployee object
        public override string ToString()
        {
            return string.Format("salaried employee: {0}\n{1}: {2:C}",
               base.ToString(), "weekly salary", WeeklySalary);
        } // end method ToString                                      
    } // end class SalariedEmployee
}
