﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections;

namespace VehicleInheritance
{
    class Vehicle
    {
        //Fields
        private string company;
        private string model;
        private decimal mrsp;
        
        private bool saleStatus;

        //for keeping track of the number of vehicles created
        public static int vehicleCount = 0; 

        //Constructor
        public Vehicle(string company, string model, decimal price)
        {
            this.company = company;
            this.model = model;
            this.mrsp = price;

            vehicleCount++;

            saleStatus = false;
        }

        //Properties
        public string Company
        {
            get { return company; }
        }
        public string Model
        {
            get { return model; }
        }
        public decimal MRSP
        {
            get { return mrsp; }
        }
        public bool SaleStatus
        {
            get
            {
                return saleStatus;
            }

        }

        //Create a Method
        public string BuyVehicle()
        {
            if (!saleStatus)
            {
                saleStatus = true;
                return "Vehicle has been bought!";
            }
            else
            {
                return "Vehicle is already sold, cannot be bought!";
            }
        }

        public static ArrayList GetVehicles()
        {
            ArrayList list = new ArrayList();
            list.Add(new Vehicle("Aston Martin", "Vantage", 129000.00m));
            list.Add(new Vehicle("Ford", "Fusion", 28678.99m));
            list.Add(new Vehicle("Honda", "Civic EX", 18713.27m));
            list.Add(new Vehicle("Mercedes Benz", "CLS550", 82010.00m));
            return list;
        }
        public override string ToString()
        {
            return string.Format("Company: {0}\n\tModel: {1}\n\tMRSP: {2:C}\n\n",
            company, model, mrsp);
        }

    }//End Class
}
