
/**
 * SalesPerson class
 * @author
 */
public class SalesPerson {

    private final int FIXED_SALARY = 50000;
    private final double CURRENT_TARGET = 120000;
    private final double COMMISSION_RATE = 0.15;
    private final double ACCELERATION_FACTOR = 1.25;

    /**
     * returns the commission
     *
     * @param totalSales
     * @return
     */
    public double getCommission(double totalSales) {
        double commission = 0.0;

        // if targets are achieved
        if (totalSales >= CURRENT_TARGET) {
            commission = ACCELERATION_FACTOR * totalSales * COMMISSION_RATE;
        } // if acheived 80% target
        else if (totalSales >= (0.8 * CURRENT_TARGET) && (totalSales < CURRENT_TARGET)) {
            commission = totalSales * COMMISSION_RATE;
        }
        return commission;
    }

    /**
     * calculated total compensation
     * @param totalSales
     * @return 
     */
    public double getTotalCompensation(double totalSales) {
        double totalCompensation = FIXED_SALARY + getCommission(totalSales);
        return totalCompensation;
    }

}
